/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.firebase.messaging.FcmOptionsUtil;

public final class FcmOptions {
    @Key(value="analytics_label")
    private final String analyticsLabel;

    private FcmOptions(Builder builder) {
        FcmOptionsUtil.checkAnalyticsLabel(builder.analyticsLabel);
        this.analyticsLabel = builder.analyticsLabel;
    }

    public static FcmOptions withAnalyticsLabel(String analyticsLabel) {
        return new Builder().setAnalyticsLabel(analyticsLabel).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String analyticsLabel;

        private Builder() {
        }

        public Builder setAnalyticsLabel(String analyticsLabel) {
            this.analyticsLabel = analyticsLabel;
            return this;
        }

        public FcmOptions build() {
            return new FcmOptions(this);
        }
    }
}

