/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.xmlrules;

import java.util.Set;
import org.apache.commons.digester3.binder.LinkedRuleBuilder;
import org.apache.commons.digester3.binder.RulesBinder;
import org.apache.commons.digester3.binder.RulesModule;
import org.apache.commons.digester3.xmlrules.BeanPropertySetterRule;
import org.apache.commons.digester3.xmlrules.CallMethodRule;
import org.apache.commons.digester3.xmlrules.CallParamRule;
import org.apache.commons.digester3.xmlrules.FactoryCreateRule;
import org.apache.commons.digester3.xmlrules.IncludeRule;
import org.apache.commons.digester3.xmlrules.NameSpaceURIRulesBinder;
import org.apache.commons.digester3.xmlrules.NodeCreateRule;
import org.apache.commons.digester3.xmlrules.ObjectCreateRule;
import org.apache.commons.digester3.xmlrules.ObjectParamRule;
import org.apache.commons.digester3.xmlrules.PatternRule;
import org.apache.commons.digester3.xmlrules.PatternStack;
import org.apache.commons.digester3.xmlrules.SetNamespaceURIRule;
import org.apache.commons.digester3.xmlrules.SetNestedPropertiesAliasRule;
import org.apache.commons.digester3.xmlrules.SetNestedPropertiesIgnoreRule;
import org.apache.commons.digester3.xmlrules.SetNestedPropertiesRule;
import org.apache.commons.digester3.xmlrules.SetNextRule;
import org.apache.commons.digester3.xmlrules.SetPropertiesAliasRule;
import org.apache.commons.digester3.xmlrules.SetPropertiesIgnoreRule;
import org.apache.commons.digester3.xmlrules.SetPropertiesRule;
import org.apache.commons.digester3.xmlrules.SetPropertyRule;
import org.apache.commons.digester3.xmlrules.SetRootRule;
import org.apache.commons.digester3.xmlrules.SetTopRule;
import org.apache.commons.digester3.xmlrules.WithMemoryRulesBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class XmlRulesModule
implements RulesModule {
    private final NameSpaceURIRulesBinder targetRulesBinder;
    private final Set<String> rootSystemIds;
    private final String rootPath;
    private WithMemoryRulesBinder memoryRulesBinder;

    public XmlRulesModule(NameSpaceURIRulesBinder targetRulesBinder, Set<String> rootSystemIds, String rootPath) {
        this.targetRulesBinder = targetRulesBinder;
        this.rootSystemIds = rootSystemIds;
        this.rootPath = rootPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(RulesBinder rulesBinder) {
        if (rulesBinder instanceof WithMemoryRulesBinder) {
            this.memoryRulesBinder = (WithMemoryRulesBinder)rulesBinder;
        } else {
            this.memoryRulesBinder = new WithMemoryRulesBinder(rulesBinder);
            if (!this.rootSystemIds.isEmpty()) {
                this.memoryRulesBinder.getIncludedFiles().addAll(this.rootSystemIds);
            }
        }
        PatternStack patternStack = this.memoryRulesBinder.getPatternStack();
        if (this.rootPath != null) {
            patternStack.push(this.rootPath);
        }
        try {
            this.forPattern("digester-rules").addRule(new SetNamespaceURIRule(this.targetRulesBinder));
            this.forPattern("*/pattern").addRule(new PatternRule(patternStack));
            this.forPattern("*/include").addRule(new IncludeRule(this.memoryRulesBinder, this.targetRulesBinder));
            this.forPattern("*/bean-property-setter-rule").addRule(new BeanPropertySetterRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/call-method-rule").addRule(new CallMethodRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/call-param-rule").addRule(new CallParamRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/factory-create-rule").addRule(new FactoryCreateRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/node-create-rule").addRule(new NodeCreateRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/object-create-rule").addRule(new ObjectCreateRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/object-param-rule").addRule(new ObjectParamRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/set-properties-rule").addRule(new SetPropertiesRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/set-properties-rule/alias").addRule(new SetPropertiesAliasRule());
            this.forPattern("*/set-properties-rule/ignore").addRule(new SetPropertiesIgnoreRule());
            this.forPattern("*/set-property-rule").addRule(new SetPropertyRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/set-nested-properties-rule").addRule(new SetNestedPropertiesRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/set-nested-properties-rule/alias").addRule(new SetNestedPropertiesAliasRule());
            this.forPattern("*/set-nested-properties-rule/ignore").addRule(new SetNestedPropertiesIgnoreRule());
            this.forPattern("*/set-top-rule").addRule(new SetTopRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/set-next-rule").addRule(new SetNextRule(this.targetRulesBinder, patternStack));
            this.forPattern("*/set-root-rule").addRule(new SetRootRule(this.targetRulesBinder, patternStack));
        }
        finally {
            this.memoryRulesBinder = null;
        }
    }

    protected LinkedRuleBuilder forPattern(String pattern) {
        return this.memoryRulesBinder.forPattern(pattern);
    }
}

