/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collection;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class AssignmentChangeEvent
extends CompletableApplicationEvent<Void> {
    private final long currentTimeMs;
    private final Collection<TopicPartition> partitions;

    public AssignmentChangeEvent(long currentTimeMs, long deadlineMs, Collection<TopicPartition> partitions) {
        super(ApplicationEvent.Type.ASSIGNMENT_CHANGE, deadlineMs);
        this.currentTimeMs = currentTimeMs;
        this.partitions = Set.copyOf(partitions);
    }

    public long currentTimeMs() {
        return this.currentTimeMs;
    }

    public Collection<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", currentTimeMs=" + this.currentTimeMs + ", partitions=" + String.valueOf(this.partitions);
    }
}

