/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.JwtRetriever;
import org.apache.kafka.common.security.oauthbearer.JwtRetrieverException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ClientCredentialsRequestFormatter;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.HttpJwtRetriever;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCredentialsJwtRetriever
implements JwtRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCredentialsJwtRetriever.class);
    private HttpJwtRetriever delegate;

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        JaasOptionsUtils jou = new JaasOptionsUtils(saslMechanism, jaasConfigEntries);
        ConfigOrJaas configOrJaas = new ConfigOrJaas(cu, jou);
        String clientId = configOrJaas.clientId();
        String clientSecret = configOrJaas.clientSecret();
        String scope = configOrJaas.scope();
        boolean urlencodeHeader = ClientCredentialsJwtRetriever.validateUrlencodeHeader(cu);
        ClientCredentialsRequestFormatter requestFormatter = new ClientCredentialsRequestFormatter(clientId, clientSecret, scope, urlencodeHeader);
        this.delegate = new HttpJwtRetriever(requestFormatter);
        this.delegate.configure(configs, saslMechanism, jaasConfigEntries);
    }

    @Override
    public String retrieve() throws JwtRetrieverException {
        if (this.delegate == null) {
            throw new IllegalStateException("JWT retriever delegate is null; please call configure() first");
        }
        return this.delegate.retrieve();
    }

    @Override
    public void close() throws IOException {
        Utils.closeQuietly(this.delegate, "JWT retriever delegate");
    }

    static boolean validateUrlencodeHeader(ConfigurationUtils configurationUtils) {
        Boolean urlencodeHeader = (Boolean)configurationUtils.get("sasl.oauthbearer.header.urlencode");
        return Objects.requireNonNullElse(urlencodeHeader, false);
    }

    private static class ConfigOrJaas {
        private final ConfigurationUtils cu;
        private final JaasOptionsUtils jou;

        private ConfigOrJaas(ConfigurationUtils cu, JaasOptionsUtils jou) {
            this.cu = cu;
            this.jou = jou;
        }

        private String clientId() {
            return this.getValue("sasl.oauthbearer.client.credentials.client.id", "clientId", true, this.cu::validateString, this.jou::validateString);
        }

        private String clientSecret() {
            return this.getValue("sasl.oauthbearer.client.credentials.client.secret", "clientSecret", true, this.cu::validatePassword, this.jou::validateString);
        }

        private String scope() {
            return this.getValue("sasl.oauthbearer.scope", "scope", false, this.cu::validateString, this.jou::validateString);
        }

        private String getValue(String configName, String jaasName, boolean isRequired, Function<String, String> configValueGetter, Function<String, String> jaasValueGetter) {
            boolean isPresentInConfig = this.cu.containsKey(configName);
            boolean isPresentInJaas = this.jou.containsKey(jaasName);
            if (isPresentInConfig) {
                if (isPresentInJaas) {
                    LOG.warn("Both the OAuth configuration {} as well as the JAAS option {} (from the {} configuration) were provided. Since the {} JAAS option is deprecated, it will be ignored and the value from the {} configuration will be used. Please update your configuration to only use {}.", new Object[]{configName, jaasName, "sasl.jaas.config", jaasName, configName, configName});
                }
                return configValueGetter.apply(configName);
            }
            if (isPresentInJaas) {
                String value = jaasValueGetter.apply(jaasName);
                LOG.warn("The OAuth JAAS option {} was configured in {}, but that JAAS option is deprecated and will be removed. Please update your configuration to use the {} configuration instead.", new Object[]{jaasName, "sasl.jaas.config", configName});
                return value;
            }
            if (isRequired) {
                throw new ConfigException(configName, (Object)null);
            }
            return null;
        }
    }
}

