/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.client;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import nu.validator.htmlparser.sax.XmlSerializer;
import nu.validator.json.Serializer;
import nu.validator.messages.GnuMessageEmitter;
import nu.validator.messages.JsonMessageEmitter;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.messages.TextMessageEmitter;
import nu.validator.messages.XmlMessageEmitter;
import nu.validator.servlet.imagereview.ImageCollector;
import nu.validator.validation.SimpleDocumentValidator;
import nu.validator.xml.SystemErrErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EmbeddedValidator {
    public static final String SCHEMA_URL = "http://s.validator.nu/html5-all.rnc";
    private boolean asciiQuotes = false;
    private boolean detectLanguages = false;
    private boolean forceHTML = false;
    private int lineOffset = 0;
    private boolean loadEntities = false;
    private boolean noStream = false;
    private OutputFormat outputFormat = OutputFormat.JSON;
    private String schemaUrl = "http://s.validator.nu/html5-all.rnc";
    private String version = "[unknown version]";

    public String validate(Path path) throws IOException, SAXException {
        try (OneOffValidator validator = new OneOffValidator(this.asciiQuotes, this.detectLanguages, this.forceHTML, this.lineOffset, this.loadEntities, this.noStream, this.outputFormat, this.schemaUrl);){
            String string = validator.validate(path);
            return string;
        }
    }

    public String validate(InputStream in) throws IOException, SAXException {
        try (OneOffValidator validator = new OneOffValidator(this.asciiQuotes, this.detectLanguages, this.forceHTML, this.lineOffset, this.loadEntities, this.noStream, this.outputFormat, this.schemaUrl);){
            String string = validator.validate(in);
            return string;
        }
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            throw new IllegalArgumentException("outputFormat can not be null");
        }
        this.outputFormat = outputFormat;
    }

    public boolean isLoadEntities() {
        return this.loadEntities;
    }

    public void setLoadEntities(boolean loadEntities) {
        this.loadEntities = loadEntities;
    }

    public boolean isNoLangDetect() {
        return this.detectLanguages;
    }

    public void setNoLangDetect(boolean noLangDetect) {
        this.detectLanguages = noLangDetect;
    }

    public boolean isNoStream() {
        return this.noStream;
    }

    public void setNoStream(boolean noStream) {
        this.noStream = noStream;
    }

    public boolean isForceHTML() {
        return this.forceHTML;
    }

    public void setForceHTML(boolean forceHTML) {
        this.forceHTML = forceHTML;
    }

    public boolean isAsciiQuotes() {
        return this.asciiQuotes;
    }

    public void setAsciiQuotes(boolean asciiQuotes) {
        this.asciiQuotes = asciiQuotes;
    }

    public int getLineOffset() {
        return this.lineOffset;
    }

    public void setLineOffset(int lineOffset) {
        this.lineOffset = lineOffset;
    }

    public String getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(String schemaUrl) {
        if (schemaUrl != null && !schemaUrl.startsWith("http:")) {
            throw new IllegalArgumentException("schemaUrl should be a URL");
        }
        this.schemaUrl = schemaUrl;
    }

    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("version should not be a null");
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public static enum OutputFormat {
        TEXT,
        XML,
        JSON,
        GNU;

    }

    private class OneOffValidator
    implements AutoCloseable {
        private static final String MSG_SUCCESS = "Document checking completed. No errors found.";
        private static final String MSG_FAIL = "Document checking completed.";
        private static final String EXTENSION_ERROR = "File was not checked. Files must have .html, .xhtml, .htm, or .xht extensions.";
        private final AtomicBoolean used = new AtomicBoolean(false);
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final BufferedOutputStream bufOut = new BufferedOutputStream(this.out);
        private final SimpleDocumentValidator validator;
        private final MessageEmitterAdapter errorHandler;
        private final boolean forceHtml;

        private OneOffValidator(boolean asciiQuotes, boolean detectLanguages, boolean forceHtml, int lineOffset, boolean loadEntities, boolean noStream, OutputFormat outputFormat, String schemaUrl) throws SAXException {
            this.validator = new SimpleDocumentValidator(true, false, !detectLanguages);
            this.errorHandler = this.newErrorHandler(lineOffset, asciiQuotes, outputFormat);
            this.forceHtml = forceHtml;
            try {
                this.validator.setUpMainSchema(schemaUrl == null ? EmbeddedValidator.SCHEMA_URL : schemaUrl, new SystemErrErrorHandler());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.validator.setUpValidatorAndParsers(this.errorHandler, noStream, loadEntities);
        }

        public MessageEmitterAdapter newErrorHandler(int lineOffset, boolean asciiQuotes, OutputFormat outputFormat) throws SAXException {
            boolean showSource = true;
            boolean batchMode = true;
            MessageEmitterAdapter adapter = new MessageEmitterAdapter(null, this.validator.getSourceCode(), showSource, new ImageCollector(this.validator.getSourceCode()), lineOffset, batchMode, this.newEmitter(asciiQuotes, outputFormat));
            adapter.setErrorsOnly(false);
            adapter.setHtml(true);
            adapter.start(null);
            return adapter;
        }

        private MessageEmitter newEmitter(boolean asciiQuotes, OutputFormat outputFormat) {
            switch (outputFormat.ordinal()) {
                case 0: {
                    return new TextMessageEmitter(this.out, asciiQuotes);
                }
                case 3: {
                    return new GnuMessageEmitter(this.out, asciiQuotes);
                }
                case 2: {
                    return new JsonMessageEmitter(new Serializer(this.out), null, asciiQuotes, EmbeddedValidator.this.version);
                }
                case 1: {
                    return new XmlMessageEmitter(new XmlSerializer(this.out));
                }
            }
            throw new UnsupportedOperationException("OutputFormat " + (Object)((Object)outputFormat) + " not supported");
        }

        private String validate(Path path) throws IOException, SAXException {
            if (!this.used.compareAndSet(false, true)) {
                throw new IllegalStateException("OneOffValidator instances are not reusable");
            }
            try {
                if (Files.notExists(path, new LinkOption[0]) || !Files.isReadable(path)) {
                    this.errorHandler.warning(new SAXParseException("File not found.", null, path.toString(), -1, -1));
                } else if (this.isXhtml(path.toFile())) {
                    if (this.forceHtml) {
                        this.validator.checkHtmlFile(path.toFile(), true);
                    } else {
                        this.validator.checkXmlFile(path.toFile());
                    }
                } else if (this.isHtml(path.toFile())) {
                    this.validator.checkHtmlFile(path.toFile(), true);
                } else {
                    this.errorHandler.warning(new SAXParseException(EXTENSION_ERROR, null, path.toString(), -1, -1));
                }
            }
            catch (SAXException e) {
                this.errorHandler.warning(new SAXParseException(e.getMessage(), null, path.toString(), -1, -1));
            }
            this.errorHandler.end(MSG_SUCCESS, MSG_FAIL, "");
            return new String(this.out.toByteArray(), StandardCharsets.UTF_8);
        }

        private boolean isXhtml(File file) {
            String name = file.getName();
            return name.endsWith(".xhtml") || name.endsWith(".xht");
        }

        private boolean isHtml(File file) {
            String name = file.getName();
            return name.endsWith(".html") || name.endsWith(".htm");
        }

        private String validate(InputStream in) throws IOException, SAXException {
            if (!this.used.compareAndSet(false, true)) {
                throw new IllegalStateException("OneOffValidator instances are not reusable");
            }
            this.validator.checkHtmlInputSource(new InputSource(in));
            this.errorHandler.end(MSG_SUCCESS, MSG_FAIL, "");
            return new String(this.out.toByteArray(), StandardCharsets.UTF_8);
        }

        @Override
        public void close() {
            try {
                this.bufOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

