/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.util.test.FreeColTestCase;

public class TileItemContainerTest
extends FreeColTestCase {
    private static final ResourceType oreRsc = TileItemContainerTest.spec().getResourceType("model.resource.ore");
    private static final TileImprovementType riverImprov = TileItemContainerTest.spec().getTileImprovementType("model.improvement.river");
    private static final TileImprovementType roadImprov = TileItemContainerTest.spec().getTileImprovementType("model.improvement.road");
    private static final TileType desert = TileItemContainerTest.spec().getTileType("model.tile.desert");
    private static final TileType plains = TileItemContainerTest.spec().getTileType("model.tile.plains");

    private TileItemContainer getSample(Game game, Tile t, boolean addImprovements, boolean addResources, boolean addRumours) {
        if (addImprovements) {
            t.addRiver(1, "0101");
            TileImprovement road = t.addRoad();
            road.setTurnsToComplete(0);
        }
        if (addResources) {
            t.addResource(new Resource(game, t, oreRsc));
        }
        if (addRumours) {
            t.add(new LostCityRumour(game, t, LostCityRumour.RumourType.FOUNTAIN_OF_YOUTH, "fountain"));
        }
        if (t.getTileItemContainer() == null) {
            t.setTileItemContainer(new TileItemContainer(game, t));
        }
        return t.getTileItemContainer();
    }

    public void testCopyFromWithEveryThing() {
        Game game = TileItemContainerTest.getStandardGame();
        Map map = TileItemContainerTest.getTestMap();
        game.changeMap(map);
        Tile tOriginal = map.getTile(8, 8);
        tOriginal.setType(plains);
        Tile tCopy = map.getTile(8, 9);
        tCopy.setType(desert);
        TileItemContainer original = this.getSample(game, tOriginal, true, true, true);
        TileItemContainer copy = this.getSample(game, tCopy, false, false, false);
        TileItemContainerTest.assertTrue((String)"Setup error, original must have road", (original.getRoad() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertFalse((String)"Setup error, copy cannot have road", (copy.getRoad() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Setup error, original must have river", (original.getRiver() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertFalse((String)"Setup error, copy cannot have river", (copy.getRiver() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Setup error, original must have resource", (original.getResource() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertFalse((String)"Setup error, copy cannot have resource", (copy.getResource() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Setup error, original must have rumour", (original.getLostCityRumour() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertFalse((String)"Setup error, copy cannot have rumour", (copy.getLostCityRumour() != null ? 1 : 0) != 0);
        copy.copyFrom(original, Map.Layer.ALL);
        TileItemContainerTest.assertTrue((String)"Copy should have road", (copy.getRoad() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Copy should have river", (copy.getRiver() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Copy should have resource", (copy.getResource() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Copy should have rumour", (copy.getLostCityRumour() != null ? 1 : 0) != 0);
        copy.copyFrom(original, Map.Layer.RESOURCES);
        TileItemContainerTest.assertFalse((String)"Copy should not have road", (copy.getRoad() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Copy should have river", (copy.getRiver() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertTrue((String)"Copy should have resource", (copy.getResource() != null ? 1 : 0) != 0);
        TileItemContainerTest.assertFalse((String)"Copy should not have rumour", (copy.getLostCityRumour() != null ? 1 : 0) != 0);
    }
}

