/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.ui.ListComponent;
import org.openide.util.Mutex;

public class PopupPane
extends JScrollPane {
    private JPanel view;
    private Set<ListComponent> listComponents = new HashSet<ListComponent>();
    private ListComponent selected;

    public PopupPane() {
        this.view = new JPanel();
        GridLayout gridLayout = new GridLayout(0, 1);
        gridLayout.setHgap(0);
        gridLayout.setVgap(0);
        this.view.setLayout(gridLayout);
        this.view.setBorder(BorderFactory.createEmptyBorder());
        this.setName("progresspopup");
        this.setVerticalScrollBarPolicy(20);
        this.setViewportView(this.view);
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        MoveDownAction moveDownAction = new MoveDownAction();
        this.getActionMap().put("Move-Down", moveDownAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "Move-Down");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 0), "Move-Down");
        MoveUpAction moveUpAction = new MoveUpAction();
        this.getActionMap().put("Move-Up", moveUpAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "Move-Up");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 0), "Move-Up");
        CancelAction cancelAction = new CancelAction();
        this.getActionMap().put("Cancel-Task", cancelAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "Cancel-Task");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "Cancel-Task");
        SelectAction selectAction = new SelectAction();
        this.getActionMap().put("select-task", selectAction);
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "select-task");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(32, 0), "select-task");
        this.setHorizontalScrollBarPolicy(31);
    }

    public void addListComponent(final ListComponent listComponent) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                PopupPane.this.listComponents.add(listComponent);
                if (PopupPane.this.view.getComponentCount() > 0) {
                    JComponent jComponent = (JComponent)PopupPane.this.view.getComponent(PopupPane.this.view.getComponentCount() - 1);
                    jComponent.setBorder(new BottomLineBorder());
                }
                listComponent.setBorder(BorderFactory.createEmptyBorder());
                PopupPane.this.view.add(listComponent);
                if (PopupPane.this.listComponents.size() > 3) {
                    PopupPane.this.setVerticalScrollBarPolicy(22);
                } else {
                    PopupPane.this.setVerticalScrollBarPolicy(21);
                }
            }
        });
    }

    public void removeListComponent(final InternalHandle internalHandle) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                JComponent jComponent;
                Iterator iterator = PopupPane.this.listComponents.iterator();
                while (iterator.hasNext()) {
                    jComponent = (ListComponent)iterator.next();
                    if (((ListComponent)jComponent).getHandle() != internalHandle) continue;
                    PopupPane.this.view.remove(jComponent);
                    iterator.remove();
                    break;
                }
                if (PopupPane.this.view.getComponentCount() > 0) {
                    jComponent = (JComponent)PopupPane.this.view.getComponent(PopupPane.this.view.getComponentCount() - 1);
                    jComponent.setBorder(null);
                }
                if (PopupPane.this.listComponents.size() > 3) {
                    PopupPane.this.setVerticalScrollBarPolicy(22);
                } else {
                    PopupPane.this.setVerticalScrollBarPolicy(21);
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.view.getComponentCount();
        int n2 = n > 0 ? this.view.getComponent((int)0).getPreferredSize().height : 0;
        int n3 = n > 3 ? n2 * 3 + 5 : n * n2 + 5;
        return new Dimension(n > 3 ? 622 : 602, n3);
    }

    public void updateBoldFont(final InternalHandle internalHandle) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                Iterator iterator = PopupPane.this.listComponents.iterator();
                while (iterator.hasNext()) {
                    ListComponent listComponent;
                    listComponent.markAsActive(internalHandle == (listComponent = (ListComponent)iterator.next()).getHandle());
                }
            }
        });
    }

    private int findIndex(Component component) {
        Component[] componentArray = this.view.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] != component) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    private class SelectAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupPane.this.selected != null) {
                PopupPane.this.selected.getHandle().requestExplicitSelection();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PopupPane.this.selected != null) {
                Action action = PopupPane.this.selected.getCancelAction();
                if (action != null) {
                    action.actionPerformed(actionEvent);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = PopupPane.this.view.getComponentCount();
            if (PopupPane.this.selected != null) {
                n = PopupPane.this.findIndex(PopupPane.this.selected);
            }
            if (--n < 0) {
                n = PopupPane.this.view.getComponentCount() - 1;
            }
            PopupPane.this.selected = (ListComponent)PopupPane.this.view.getComponent(n);
            PopupPane.this.selected.requestFocus();
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            if (PopupPane.this.selected != null) {
                n = PopupPane.this.findIndex(PopupPane.this.selected);
            }
            if (++n >= PopupPane.this.view.getComponentCount()) {
                n = 0;
            }
            PopupPane.this.selected = (ListComponent)PopupPane.this.view.getComponent(n);
            PopupPane.this.selected.requestFocus();
        }
    }

    private static class BottomLineBorder
    implements Border {
        private Insets ins = new Insets(0, 0, 1, 0);
        private Color col = UIManager.getColor("Separator.foreground");

        public BottomLineBorder() {
            if (this.col == null) {
                this.col = new Color(221, 229, 248);
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.ins;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.col);
            graphics.drawRect(n, n2 + n4 - 2, n3, 1);
            graphics.setColor(color);
        }
    }
}

