/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    function addOptionalDependency(name) {
        if (installer.componentByName(name))
            component.addDependency(name);
    };

    installer.valueChanged.connect(this, Component.prototype.reactOnTargetDirChange);

    if (installer.value("os") == "win") {
        addOptionalDependency("qt.tools.vcredist_msvc2019_x86");
        addOptionalDependency("qt.tools.vcredist_msvc2022_x64");
        addOptionalDependency("qt.tools.vcredist_msvc2022_arm64");
    }

    // set the default values to SDKToolBinary and QtCreatorInstallerSettingsFile
    Component.prototype.reactOnTargetDirChange("TargetDir", installer.value("TargetDir"));

    // add dependency to licenseservice only if component is available
    if (isEditionCommercial())
        addOptionalDependency("tools.licenseservice");
}

Component.prototype.beginInstallation = function()
{
    if (installer.value("os") === "win")
        component.addStopProcessForUpdateRequest(component.qtCreatorBinaryPath);
}

Component.prototype.reactOnTargetDirChange = function(key, value)
{
    if (key == "TargetDir") {
        component.qtCreatorBinaryPath = value;
        if (installer.value("os") == "win") {
            component.qtCreatorBinaryPath = value + "\\/Qt Creator 19.0.0-beta1.app\\bin\\qtcreator.exe";
            component.qtCreatorBinaryPath = component.qtCreatorBinaryPath.replace(/\//g, "\\");
        } else if (installer.value("os") == "mac") {
            component.qtCreatorBinaryPath = value + "//Qt Creator 19.0.0-beta1.app/Contents/MacOS/Qt Creator";
            // fix duplicate forward slashes in path
            component.qtCreatorBinaryPath = component.qtCreatorBinaryPath.replace(/\/+/g, "/");
        } else {
            component.qtCreatorBinaryPath = value + "//Qt Creator 19.0.0-beta1.app/bin/qtcreator";
            // fix duplicate forward slashes in path
            component.qtCreatorBinaryPath = component.qtCreatorBinaryPath.replace(/\/+/g, "/");
        }
    }
}

isEditionCommercial = function()
{
    var isOpenSource = "true";
    // check if OPENSOURCE flag is set to 'false' or not defined
    if (['false', 'no', '0', "", null].indexOf(isOpenSource) >= 0)
        return true
    return false
}
Component.prototype.createOperations = function()
{
    // Call the base createOperations and afterwards set some registry settings
    component.createOperations();

    // set edition string
    var edition = "Community"
    if (isEditionCommercial())
        edition = "Enterprise"

    if (installer.value("os") == "win") {
        component.addOperation("CreateShortcut",
                               component.qtCreatorBinaryPath,
                               "@StartMenuDir@\\Qt Creator 19.0.0-beta1 (" + edition + ").lnk",
                               "workingDirectory=@homeDir@");
    }
    if (installer.value("os") == "x11") {
        component.addOperation("InstallIcons", installer.value("TargetDir") + "/Qt Creator 19.0.0-beta1.app/share/icons" );
        component.addOperation( "CreateDesktopEntry",
                                "org.qt-project.qtcreator.desktop",
                                "Type=Application\nExec=\"" + component.qtCreatorBinaryPath + "\" %F\nName=Qt Creator\nGenericName=The IDE of choice for Qt development.\nIcon=QtProject-qtcreator\nStartupWMClass=qtcreator\nTerminal=false\nCategories=Development;IDE;Qt;\nMimeType=text/x-c++src;text/x-c++hdr;text/x-xsrc;application/x-designer;application/vnd.qt.qmakeprofile;application/vnd.qt.xml.resource;text/x-qml;text/x-qt.qml;text/x-qt.qbs;");
    }
}
