/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2006-09-19
 * Description : GPS file list view item.
 *
 * Copyright (C) 2006-2008 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef GPSLISTVIEWITEM_H
#define GPSLISTVIEWITEM_H

// TQt includes.

#include <tqdatetime.h>
#include <tqstring.h>

// KDE includes.

#include <kurl.h>
#include <tdelistview.h>

// Local includes.

#include "gpsdatacontainer.h"

class TQPainter;
class TQColorGroup;
class TQPixmap;

namespace KIPIGPSSyncPlugin
{
class GPSListViewItemPriv;

class GPSListViewItem : public TDEListViewItem
{

public:

    GPSListViewItem(TDEListView *view, TQListViewItem *after, const KURL& url);
    ~GPSListViewItem();

    void setGPSInfo(const GPSDataContainer& gpsData, bool dirty=true, bool addedManually=false);
    GPSDataContainer GPSInfo() const;
    void eraseGPSInfo();

    void setDateTime(const TQDateTime &date);
    TQDateTime dateTime() const;

    void setEnabled(bool e);
    bool isEnabled();
    bool isDirty();
    bool isInterpolated();
    bool hasGPSInfo();

    KURL url();
    void writeGPSInfoToFile();

protected:

    void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment);

private: 

    GPSListViewItemPriv *d;
};

} // NameSpace KIPIGPSSyncPlugin

#endif /* GPSLISTVIEWITEM_H */
