// File autogenerated

// declaration include
#include "deviceproxy.h"

// TQt includes
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

DeviceProxy::DeviceProxy(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.Device");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

DeviceProxy::~DeviceProxy()
{
    delete m_baseProxy;
}

void DeviceProxy::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool DeviceProxy::DisconnectAsync(int& asyncCallId, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    asyncCallId = m_baseProxy->sendWithAsyncReply("Disconnect", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "Disconnect";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void DeviceProxy::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant DeviceProxy::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString DeviceProxy::getUdi(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Udi", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString DeviceProxy::getInterface(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Interface", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString DeviceProxy::getIpInterface(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("IpInterface", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString DeviceProxy::getDriver(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Driver", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString DeviceProxy::getDriverVersion(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("DriverVersion", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQString DeviceProxy::getFirmwareVersion(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("FirmwareVersion", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 DeviceProxy::getCapabilities(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Capabilities", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_INT32 DeviceProxy::getIp4Address(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Ip4Address", error);

    if (error.isValid()) return TQ_INT32();

    bool ok = false;

    TQ_INT32 result =  variant.value.toInt32(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 DeviceProxy::getState(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("State", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusData DeviceProxy::getStateReason(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("StateReason", error);

    if (error.isValid()) return TQT_DBusData();

    TQT_DBusData result = variant.value;
    return result;
}

TQT_DBusObjectPath DeviceProxy::getActiveConnection(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("ActiveConnection", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath DeviceProxy::getIp4Config(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Ip4Config", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath DeviceProxy::getDhcp4Config(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Dhcp4Config", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath DeviceProxy::getIp6Config(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Ip6Config", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

TQT_DBusObjectPath DeviceProxy::getDhcp6Config(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Dhcp6Config", error);

    if (error.isValid()) return TQT_DBusObjectPath();

    bool ok = false;

    TQT_DBusObjectPath result =  variant.value.toObjectPath(&ok);
    if (!ok) {}

    return result;
}

bool DeviceProxy::getManaged(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Managed", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void DeviceProxy::setAutoconnect(bool value, TQT_DBusError& error)
{
    TQT_DBusVariant variant;
    variant.value = TQT_DBusData::fromBool(value);
    variant.signature = "b";

    setDBusProperty("Autoconnect", variant, error);
}

bool DeviceProxy::getAutoconnect(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Autoconnect", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

bool DeviceProxy::getFirmwareMissing(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("FirmwareMissing", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

TQ_UINT32 DeviceProxy::getDeviceType(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("DeviceType", error);

    if (error.isValid()) return TQ_UINT32();

    bool ok = false;

    TQ_UINT32 result =  variant.value.toUInt32(&ok);
    if (!ok) {}

    return result;
}

TQValueList< TQT_DBusObjectPath > DeviceProxy::getAvailableConnections(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("AvailableConnections", error);

    if (error.isValid()) return TQValueList< TQT_DBusObjectPath >();

    bool ok = false;

    bool subOK = false;

    TQValueList< TQT_DBusObjectPath > result =  variant.value.toList(&ok).toObjectPathList(&subOK);
    if (!subOK) {}
    if (!ok) {}

    return result;
}

void DeviceProxy::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "StateChanged")
    {
        TQ_UINT32 _new_state = message[0].toUInt32();
        TQ_UINT32 _old_state = message[1].toUInt32();
        TQ_UINT32 _reason = message[2].toUInt32();

        emit StateChanged(_new_state, _old_state, _reason);
    }
}

void DeviceProxy::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "Disconnect")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit DisconnectAsyncReply(_asyncCallId);
    }
}

}; // namespace DBus

#include "deviceproxy.moc"

// End of File

