// File autogenerated

// declaration include
#include "networkmanagersettings.h"

// TQt includes
#include <tqmap.h>
#include <tqstring.h>
#include <tqvaluelist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusdata.h>
#include <tqdbusdatalist.h>
#include <tqdbusdatamap.h>
#include <tqdbuserror.h>
#include <tqdbusmessage.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusvariant.h>


namespace DBus
{

SettingsInterface::SettingsInterface(const TQString& service, const TQString& path, TQObject* parent, const char* name)
    : TQObject(parent, name),
      m_baseProxy(new TQT_DBusProxy())
{
    m_baseProxy->setInterface("org.freedesktop.NetworkManager.Settings");
    m_baseProxy->setPath(path);
    m_baseProxy->setService(service);

    TQObject::connect(m_baseProxy, TQ_SIGNAL(dbusSignal(const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleDBusSignal(const TQT_DBusMessage&)));
    TQObject::connect(m_baseProxy, TQ_SIGNAL(asyncReply(int, const TQT_DBusMessage&)),
                     this,        TQ_SLOT(slotHandleAsyncReply(int, const TQT_DBusMessage&)));
}

SettingsInterface::~SettingsInterface()
{
    delete m_baseProxy;
}

void SettingsInterface::setConnection(const TQT_DBusConnection& connection)
{
    m_baseProxy->setConnection(connection);
}

bool SettingsInterface::ListConnections(TQValueList< TQT_DBusObjectPath >& connections, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;


    TQT_DBusMessage reply = m_baseProxy->sendWithReply("ListConnections", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    bool subOK = false;

    connections = reply.front().toList(&ok).toObjectPathList(&subOK);
    if (!subOK) return false;
    if (!ok) return false;

    return true;
}

bool SettingsInterface::GetConnectionByUuid(const TQString& uuid, TQT_DBusObjectPath& connection, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(uuid);

    TQT_DBusMessage reply = m_baseProxy->sendWithReply("GetConnectionByUuid", parameters, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return false;

    if (reply.count() != 1) return false;

    bool ok = false;

    connection = reply.front().toObjectPath(&ok);
    if (!ok) return false;

    return true;
}

bool SettingsInterface::AddConnectionAsync(int& asyncCallId, const TQT_DBusDataMap< TQString >& connection, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromStringKeyMap(connection);

    asyncCallId = m_baseProxy->sendWithAsyncReply("AddConnection", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "AddConnection";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

bool SettingsInterface::SaveHostnameAsync(int& asyncCallId, const TQString& hostname, TQT_DBusError& error)
{
    TQValueList<TQT_DBusData> parameters;

    parameters << TQT_DBusData::fromString(hostname);

    asyncCallId = m_baseProxy->sendWithAsyncReply("SaveHostname", parameters);

    if (asyncCallId != 0) m_asyncCalls[asyncCallId] = "SaveHostname";

    error = TQT_DBusError();
    return (asyncCallId != 0);
}

void SettingsInterface::setDBusProperty(const TQString& name, const TQT_DBusVariant& value, TQT_DBusError& error)
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Set");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);
    message << TQT_DBusData::fromVariant(value);

    connection.sendWithReply(message, &error);
}

TQT_DBusVariant SettingsInterface::getDBusProperty(const TQString& name, TQT_DBusError& error) const
{
    TQT_DBusConnection connection = m_baseProxy->connection();

    TQT_DBusMessage message = TQT_DBusMessage::methodCall(m_baseProxy->service(), m_baseProxy->path(), "org.freedesktop.DBus.Properties", "Get");

    message << TQT_DBusData::fromString(m_baseProxy->interface());
    message << TQT_DBusData::fromString(name);

    TQT_DBusMessage reply = connection.sendWithReply(message, &error);

    if (reply.type() != TQT_DBusMessage::ReplyMessage) return TQT_DBusVariant();
    if (reply.count() != 1) return TQT_DBusVariant();

    bool ok = false;
    TQT_DBusVariant value = reply.front().toVariant(&ok);
    if (!ok) return TQT_DBusVariant();

    return value;
}

TQString SettingsInterface::getHostname(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("Hostname", error);

    if (error.isValid()) return TQString();

    bool ok = false;

    TQString result =  variant.value.toString(&ok);
    if (!ok) {}

    return result;
}

bool SettingsInterface::getCanModify(TQT_DBusError& error) const
{
    TQT_DBusVariant variant = getDBusProperty("CanModify", error);

    if (error.isValid()) return bool();

    bool ok = false;

    bool result =  variant.value.toBool(&ok);
    if (!ok) {}

    return result;
}

void SettingsInterface::slotHandleDBusSignal(const TQT_DBusMessage& message)
{
    if (message.member() == "PropertiesChanged")
    {
        TQMap< TQString, TQT_DBusVariant > _properties = message[0].toStringKeyMap().toVariantMap();

        emit PropertiesChanged(_properties);
    }
    else if (message.member() == "NewConnection")
    {
        TQT_DBusObjectPath _connection = message[0].toObjectPath();

        emit NewConnection(_connection);
    }
}

void SettingsInterface::slotHandleAsyncReply(int asyncCallId, const TQT_DBusMessage& message)
{
    TQMap<int, TQString>::iterator findIt = m_asyncCalls.find(asyncCallId);
    if (findIt == m_asyncCalls.end()) return;

    const TQString signalName = findIt.data();
    m_asyncCalls.erase(findIt);

    if (signalName == "AddConnection")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }

        TQT_DBusObjectPath _path = message[0].toObjectPath();

        emit AddConnectionAsyncReply(_asyncCallId, _path);
    }
    else if (signalName == "SaveHostname")
    {
        int _asyncCallId = asyncCallId;

        if (message.type() == TQT_DBusMessage::ErrorMessage) {
            emit AsyncErrorResponseDetected(_asyncCallId, message.error());
        }


        emit SaveHostnameAsyncReply(_asyncCallId);
    }
}

}; // namespace DBus

#include "networkmanagersettings.moc"

// End of File

