// File autogenerated

// declaration include
#include "dbusbaseNode.h"

// TQt includes
#include <tqdom.h>
#include <tqmap.h>
#include <tqstringlist.h>

// TQt D-Bus includes
#include <tqdbusconnection.h>
#include <tqdbusmessage.h>


// interface classes includes
#include "dbusbaseNode.h"
#include "introspectableInterface.h"


class DBusBaseNode::Private : public org::freedesktop::DBus::IntrospectableInterface
{
public:
    virtual ~Private();

public:
    TQMap<TQString, TQT_DBusObjectBase*> interfaces;
    TQString introspectionData;

    TQT_DBusConnection connection;
    TQString objectPath;
    TQStringList childrenNodes;

protected:
    virtual bool Introspect(TQString& data, TQT_DBusError& error);

    virtual void handleMethodReply(const TQT_DBusMessage& reply);
private:
    void cacheIntrospectionData();
};

DBusBaseNode::DBusBaseNode()  : TQT_DBusObjectBase(),
    m_private(new Private())
{
}

DBusBaseNode::~DBusBaseNode()
{
    unregisterObject();

    delete m_private;
}

bool DBusBaseNode::registerObject(const TQT_DBusConnection& connection, const TQString& path)
{
    if (path.isEmpty()) return false;

    if (!m_private->objectPath.isEmpty()) unregisterObject();

    m_private->connection = connection;
    m_private->objectPath = path;

    if (!m_private->connection.registerObject(path, this))
    {
        m_private->connection = TQT_DBusConnection();
        m_private->objectPath = TQString();

        return false;
    }

    if (m_private->interfaces.isEmpty())
    {
        TQString name = "org.freedesktop.DBus.Introspectable";
        TQT_DBusObjectBase* interface = m_private;
        m_private->interfaces.insert(name, interface);
    }

    return true;
}

void DBusBaseNode::addChildNode(const TQString& child)
{
    m_private->childrenNodes.append(child);
}

void DBusBaseNode::unregisterObject()
{
    if (m_private->objectPath.isEmpty()) return;

    m_private->connection.unregisterObject(m_private->objectPath);

    m_private->connection = TQT_DBusConnection();
    m_private->objectPath = TQString();
}

bool DBusBaseNode::handleMethodCall(const TQT_DBusMessage& message)
{
    TQMap<TQString, TQT_DBusObjectBase*>::iterator findIt = m_private->interfaces.find(message.interface());
    if (findIt == m_private->interfaces.end()) return false;

    return delegateMethodCall(message, findIt.data());
}

DBusBaseNode::Private::~Private()
{
    TQMap<TQString, TQT_DBusObjectBase*>::const_iterator it    = interfaces.begin();
    TQMap<TQString, TQT_DBusObjectBase*>::const_iterator endIt = interfaces.end();
    for (; it != endIt; ++it)
    {
        TQT_DBusObjectBase* interface = it.data();
        if (interface != this)
            delete interface;
    }
    interfaces.clear();
}

bool DBusBaseNode::Private::Introspect(TQString& data, TQT_DBusError& error)
{
    Q_UNUSED(error);
    if (introspectionData.isEmpty()) cacheIntrospectionData();

    data = introspectionData;

    return true;
}

void DBusBaseNode::Private::handleMethodReply(const TQT_DBusMessage& reply)
{
    connection.send(reply);
}

void DBusBaseNode::Private::cacheIntrospectionData()
{
    TQDomDocument doc;
    TQDomElement interfaceElement;
    TQDomElement nodeElement = doc.createElement("node");
    if (!objectPath.isEmpty() && objectPath.compare("/") != 0)
    {
         nodeElement.setAttribute ( "name", objectPath );
    }
    // Introspectable is added by default. Show it only if there is interface
    if (interfaces.count()>1) {
         interfaceElement = doc.createElement("interface");
         org::freedesktop::DBus::IntrospectableInterface::buildIntrospectionData(interfaceElement);
         nodeElement.appendChild(interfaceElement);
    }

    if (!childrenNodes.isEmpty()) {
        for (TQStringList::Iterator it = childrenNodes.begin(); it != childrenNodes.end(); ++it ) {
            TQDomElement nodeElement1 = doc.createElement("node");
            nodeElement1.setAttribute ( "name", *it );
            nodeElement.appendChild(nodeElement1);
        }
    }

    doc.appendChild(nodeElement);

    introspectionData = "<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\"\n\"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n";
    introspectionData += doc.toString();
}

// End of File

