/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2008-08-04
 * Description : RAW preview widget.
 *
 * Copyright (C) 2008 Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef RAWPREVIEW_H
#define RAWPREVIEW_H

// TQt includes.

#include <tqimage.h>

// KDE includes.

#include <kurl.h>

// Local includes.

#include "dimg.h"
#include "previewwidget.h"
#include "digikam_export.h"

class TQPixmap;

namespace Digikam
{

class LoadingDescription;
class RawPreviewPriv;

class DIGIKAM_EXPORT RawPreview : public PreviewWidget
{

TQ_OBJECT
  

public:

    RawPreview(const KURL& url, TQWidget *parent);
    ~RawPreview();

    DImg& demosaicedImage() const;
    DImg& postProcessedImage() const;

    void setDecodingSettings(const DRawDecoding& settings);
    void setPostProcessedImage(const DImg& image);

    void cancelLoading();

signals:

    void signalLoadingStarted();
    void signalLoadingProgress(float);
    void signalLoadingFailed();
    void signalDemosaicedImage();
    void signalPostProcessedImage();

protected:

    void resizeEvent(TQResizeEvent* e);

private slots:

    void slotLoadingProgress(const LoadingDescription& description, float progress);
    void slotImageLoaded(const LoadingDescription& description, const DImg &image);
    void slotThemeChanged();
    void slotCornerButtonPressed();
    void slotPanIconSelectionMoved(const TQRect&, bool);
    void slotPanIconHiden();

private:

    void setdemosaicedImg(const DImg& image);
    void postProcessing(const DRawDecoding& settings);
    int  previewWidth();
    int  previewHeight();
    bool previewIsNull();
    void resetPreview();
    void zoomFactorChanged(double zoom);
    void updateZoomAndSize(bool alwaysFitToWindow);
    inline void paintPreview(TQPixmap *pix, int sx, int sy, int sw, int sh);

private:

    RawPreviewPriv* d;
};

}  // NameSpace Digikam

#endif /* RAWPREVIEW_H */
