/* 
 *
 * $Id: k3bmusicbrainz.h 619556 2007-01-03 17:38:12Z trueg $
 * Copyright (C) 2005 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2007 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef _K3B_MUSICBRAINZ_H_
#define _K3B_MUSICBRAINZ_H_

#include <config.h>

#ifdef HAVE_MUSICBRAINZ

#include <tqcstring.h>
#include <tqstring.h>


/**
 * A wrapper class around libmusicbrainz. Use in combination with K3bTRM.
 *
 * Tries to determine the artist and title related to a trm.
 */
class K3bMusicBrainz
{
 public:
  K3bMusicBrainz();
  ~K3bMusicBrainz();

  /**
   * \return number of found results.
   */
  int query( const TQCString& trm );

  const TQString& title( unsigned int i = 0 ) const;
  const TQString& artist( unsigned int i = 0 ) const;

 private:
  class Private;
  Private* d;
};


#endif

#endif
