/*
 * pref.cpp
 *
 * Copyright (C) 2004-2005 Jürgen Kofler <kaffeine@gmx.net>
 * Copyright (C) 2005-2007 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pref.h"
#include "pref.moc"

#include <tdeglobal.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <tdefiledialog.h>
#include <kiconloader.h>
#include <tdelocale.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqgroupbox.h>
#include <tqlineedit.h>

#include <tqtextcodec.h>

#include <kcharsets.h>

KaffeinePreferences::KaffeinePreferences() : KDialogBase(IconList,i18n("Kaffeine Setup"), Ok|Apply|Cancel, Ok)
{
	TQGroupBox *gb;
	TQVBoxLayout *vb;
	TQGridLayout *grid;
	TDEIconLoader *icon = new TDEIconLoader();

	setInitialSize(TQSize(400,400), false);

//-----------behavior----------------
	TQFrame *behavior = addPage(i18n("Behavior"), i18n("Behavior"), TDEGlobal::iconLoader()->loadIcon("kaffeine", TDEIcon::Panel, TDEIcon::SizeMedium));
	vb = new TQVBoxLayout( behavior, 6, 6 );
	gb = new TQGroupBox( "", behavior );
	grid = new TQGridLayout( gb, 1, 1, 20, 6 );
	m_pauseVideo = new TQCheckBox(i18n("Pause video when window is minimized"), gb);
	grid->addMultiCellWidget(m_pauseVideo, 0, 0, 0, 1);
	vb->addWidget( gb );

	vb->addItem( new TQSpacerItem( 20, 20, TQSizePolicy::Ignored, TQSizePolicy::Ignored ) );

//-----------appearance--------------
	TQFrame *looknfeel = addPage(i18n("Appearance"), i18n("Appearance"),TDEGlobal::iconLoader()->loadIcon("preferences-desktop", TDEIcon::Panel, TDEIcon::SizeMedium));
	vb = new TQVBoxLayout( looknfeel, 6, 6 );
	gb = new TQGroupBox( "", looknfeel );
	grid = new TQGridLayout( gb, 1, 1, 20, 6 );
	m_systemTray = new TQCheckBox(i18n("Embed in system tray"), gb);
	connect(m_systemTray, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotEmbedInTrayToggled(bool)));
	grid->addMultiCellWidget(m_systemTray, 0, 0, 0, 1);
	m_osdTimeout = new TQSpinBox(gb);
	m_osdTimeout->setMinValue(0);
	m_osdTimeout->setMaxValue(60);
	m_osdTimeout->setSuffix(i18n(" sec"));
	m_osdTimeout->setSpecialValueText(i18n("off"));
	grid->addWidget(m_osdTimeout, 1,0);
	TQLabel* osdTimeoutLabel = new TQLabel(i18n("Duration of title announcement in system tray"), gb);
	osdTimeoutLabel->setDisabled(true);
	connect(m_systemTray, TQ_SIGNAL(toggled(bool)), osdTimeoutLabel, TQ_SLOT(setEnabled(bool)));
	grid->addWidget(osdTimeoutLabel, 1,1);
	vb->addWidget( gb );

	vb->addItem( new TQSpacerItem( 20, 20, TQSizePolicy::Ignored, TQSizePolicy::Ignored ) );

//-----------dvbclient--------------
	TQFrame *dc = addPage(i18n("DVB Client"), i18n("DVB Client"),TDEGlobal::iconLoader()->loadIcon("network_local", TDEIcon::Panel, TDEIcon::SizeMedium));
	vb = new TQVBoxLayout( dc, 6, 6 );
	m_dcEnabled = new TQCheckBox(i18n("Enable DVB client"), dc);
	vb->addWidget( m_dcEnabled );
	gb = new TQGroupBox( "", dc );
	gb->setDisabled(true);
	connect(m_dcEnabled, TQ_SIGNAL(toggled(bool)), gb, TQ_SLOT(setEnabled(bool)));
	grid = new TQGridLayout( gb, 1, 1, 20, 6 );
	TQLabel *lab = new TQLabel( i18n("Broadcast address:"), gb );
	grid->addWidget( lab, 0, 0 );
	m_dcAddress = new TQLineEdit( gb );
	grid->addWidget( m_dcAddress, 0, 1 );
	lab = new TQLabel( i18n("Broadcast port:"), gb );
	grid->addWidget( lab, 1, 0 );
	m_dcPort = new TQSpinBox( 1, 65535, 1, gb );
	grid->addWidget( m_dcPort, 1, 1 );
	lab = new TQLabel( i18n("Info port:"), gb );
	grid->addWidget( lab, 2, 0 );
	m_dcInfo = new TQSpinBox( 1, 65535, 1, gb );
	grid->addWidget( m_dcInfo, 2, 1 );

	lab = new TQLabel( i18n("Time shifting directory:"), gb );
	grid->addWidget( lab, 3, 0 );
	m_shiftDirLe = new TQLineEdit( gb );
	m_shiftDirLe->setReadOnly( true );
	grid->addWidget( m_shiftDirLe, 3, 1 );
	m_shiftDirBtn = new TQToolButton( gb );
	m_shiftDirBtn->setIconSet( icon->loadIconSet("document-open", TDEIcon::Small) );
	grid->addWidget( m_shiftDirBtn, 3, 2 );
	connect( m_shiftDirBtn, TQ_SIGNAL(clicked()), this, TQ_SLOT(setShiftDir()) );

	vb->addWidget( gb );
	vb->addItem( new TQSpacerItem( 20, 20, TQSizePolicy::Ignored, TQSizePolicy::Ignored ) );

//-----------misc----------------
	TQFrame *misc = addPage(i18n("Misc"), i18n("Miscellaneous Options"),TDEGlobal::iconLoader()->loadIcon("misc", TDEIcon::Panel, TDEIcon::SizeMedium));
	vb = new TQVBoxLayout( misc, 6, 6 );
	gb = new TQGroupBox(1, TQt::Horizontal, "", misc);
	gb->setInsideMargin(20);
	gb->setInsideSpacing(6);

	m_useAlternateEncoding = new TQCheckBox(i18n("Use alternate (non-Unicode) encoding for Meta tags"), gb);
	connect(m_useAlternateEncoding, TQ_SIGNAL(toggled(bool)), this, TQ_SLOT(slotUseAlternateEncodingToggled(bool)));

	m_alternateEncoding = new TQComboBox(gb);
	TQStringList codecNames = TDEGlobal::charsets()->descriptiveEncodingNames();
	codecNames.sort();
	m_alternateEncoding->insertStringList(codecNames);
	vb->addWidget( gb );

	gb = new TQGroupBox( "", misc );
	grid = new TQGridLayout( gb, 1, 1, 20, 6 );
	KPushButton* clearRecent = new KPushButton( i18n("Clear"), gb);
	clearRecent->setSizePolicy( TQSizePolicy (TQSizePolicy::Minimum, TQSizePolicy::Fixed));
	connect(clearRecent, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(signalClearRecent()));
	grid->addWidget(clearRecent, 0, 0);
	TQLabel* clearLabel = new TQLabel(i18n("Clear recent files list"), gb);
	grid->addWidget(clearLabel, 0, 1);
	vb->addWidget( gb );

	vb->addItem( new TQSpacerItem( 20, 20, TQSizePolicy::Ignored, TQSizePolicy::Ignored ) );

	delete icon;

	connect(this, TQ_SIGNAL(okClicked()), TQ_SLOT(slotOkPressed()));
	connect(this, TQ_SIGNAL(applyClicked()), TQ_SLOT(slotApplyPressed()));
}

void KaffeinePreferences::setConfig(bool pauseVideo, bool tray, uint duration, bool useEncoding, const TQString& encoding)
{
	m_osdTimeout->setValue(duration);
	m_osdTimeout->setEnabled(tray);
	m_systemTray->setChecked(tray);

	bool m_useEncoding = false;
	for (int i = 0; i < m_alternateEncoding->count(); ++i) {
		if (TDEGlobal::charsets()->encodingForName(m_alternateEncoding->text(i)).lower() == encoding.lower()) {
			m_useEncoding = useEncoding;
			m_alternateEncoding->setCurrentItem(i);
			break;
		}
	}

	m_useAlternateEncoding->setChecked(m_useEncoding);
	m_alternateEncoding->setEnabled(m_useEncoding);
	m_pauseVideo->setChecked(pauseVideo);
}

void KaffeinePreferences::setDvbClient( bool enabled, const TQString &address, int port, int info, const TQString &tspath )
{
	m_dcEnabled->setChecked(enabled);
	m_dcAddress->setText(address);
	m_dcPort->setValue(port);
	m_dcInfo->setValue(info);
	m_shiftDirLe->setText(tspath);
}

void KaffeinePreferences::slotApplyPressed()
{
	emit signalEmbedSystemTray(m_systemTray->isChecked());
	emit signalUseAlternateEncoding(m_useAlternateEncoding->isChecked());
	emit signalAlternateEncoding(TDEGlobal::charsets()->encodingForName(m_alternateEncoding->currentText()));
	emit signalSetOSDTimeout(m_osdTimeout->value());
	emit signalPauseVideo(m_pauseVideo->isChecked());
	emit signalDvbClient(m_dcEnabled->isChecked(), m_dcAddress->text().stripWhiteSpace(), m_dcPort->value(), m_dcInfo->value(), m_shiftDirLe->text() );
}

void KaffeinePreferences::slotOkPressed()
{
	slotApplyPressed();
	hide();
}

void KaffeinePreferences::setShiftDir()
{
	TQString s = KFileDialog::getExistingDirectory( m_shiftDirLe->text().stripWhiteSpace() );
	if ( !s.isEmpty() )
		m_shiftDirLe->setText( s );
}

void KaffeinePreferences::slotUseAlternateEncodingToggled(bool on)
{
	m_alternateEncoding->setEnabled(on);
}

void KaffeinePreferences::slotEmbedInTrayToggled(bool on)
{
	m_osdTimeout->setEnabled(on);
}
