/***************************************************************************
    begin                : Sat 3-1 20:40:00 CEST 2004
    copyright            : (C) 2004 by Jeroen Wijnhout
    email                : Jeroen.Wijnhout@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KILETOOLCONFIGWIDGET_H
#define KILETOOLCONFIGWIDGET_H

#include <tqstringlist.h>

#include <keditlistbox.h>

#include "kiletool.h"

class TQGridLayout;

namespace KileTool { class Manager; }
class ToolConfigWidget;
class ProcessToolConfigWidget;
class LibraryToolConfigWidget;
class QuickToolConfigWidget;
class LaTeXToolConfigWidget;
class ViewBibToolConfigWidget;

namespace KileWidget
{
	class ToolConfig : public TQWidget
	{
		TQ_OBJECT
  

		enum GeneralBasicStack { GBS_None = 1, GBS_Process, GBS_Library, GBS_DocPart, GBS_Sequence, GBS_Error };
		enum GeneralExtraStack { GES_None = 1, GES_LaTeX/*, GES_ViewBib*/ };

	public:
		ToolConfig(KileTool::Manager *mngr, TQWidget *parent, const char * name = 0);

	public slots:
		void writeConfig();

	private:
		void setupAdvanced();
		void setupGeneral();
		int indexQuickBuild();
		
	private slots:
		void updateGeneral();
		void updateAdvanced();
		void switchTo(const TQString & tool, bool save = true);
		void updateToollist();
		void updateConfiglist();
		void selectIcon();
		void setMenu(const TQString &);
		void switchConfig(int index = -1);
		void switchConfig(const TQString &);

		void newTool();
		void newConfig();
		void removeTool();
		void removeConfig();
		void writeStdConfig(const TQString &, const TQString &);
		void writeDefaults();

		void setCommand(const TQString &);
		void setOptions(const TQString &);
		void setLibrary(const TQString &);
		void setLibOptions(const TQString &);
		void setClassName(const TQString &);
		void setState(const TQString &);
		void setSequence(const TQString &);
		void setClose(bool);
		void setTarget(const TQString &);
		void setRelDir(const TQString &);
		void setLaTeXCheckRoot(bool);
		void setLaTeXJump(bool);
		void setLaTeXAuto(bool);
		void setRunLyxServer(bool);
		void setFrom(const TQString &);
		void setTo(const TQString &);
		void setClass(const TQString &);
		void switchClass(const TQString &);
		void switchType(int);

	signals:
		void changed();

	private:
		ToolConfigWidget	*m_configWidget;
		KileTool::Manager	*m_manager;
		TDEConfig			*m_config;
		KileTool::Config	m_map;
		TQGridLayout		*m_layout;
		TQString			m_current, m_icon;
		TQStringList		m_classes;
		TQWidget			*m_tabGeneral, *m_tabAdvanced, *m_tabMenu;
		ProcessToolConfigWidget	*m_ptcw;
		LibraryToolConfigWidget	*m_ltcw;
		QuickToolConfigWidget	*m_qtcw;
		LaTeXToolConfigWidget	*m_LaTeXtcw;
	};
}

#endif
