/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2003-10-01
 * Description : Acquire image dialog
 *
 * Copyright (C) 2003-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef ACQUIREIMAGEDIALOG_H
#define ACQUIREIMAGEDIALOG_H

// Include files for TQt

#include <tqimage.h>
#include <tqstring.h>
#include <tqfileinfo.h>
#include <tqguardedptr.h>

// Include files for KDE

#include <kdialogbase.h>
#include <tdeio/job.h>
#include <kurl.h>

// Include files for KIPI

#include <libkipi/interface.h>
#include <libkipi/uploadwidget.h>

// Local includes

#include "kpaboutdata.h"

class TQPushButton;
class TQLineEdit;
class TQLabel;
class TQTextEdit;
class TQComboBox;
class TQFrame;
class TQPushButton;

class TDEListBox;
class TDEConfig;
class KIntNumInput;
class KSqueezedTextLabel;

namespace KIPIAcquireImagesPlugin
{

class AcquireImageDialog : public KDialogBase
{
    TQ_OBJECT


public:
 
   AcquireImageDialog( KIPI::Interface* interface, TQWidget *parent=0, const TQImage &img=0);
   ~AcquireImageDialog();

private slots:
 
   void slotHelp();
   void slotOk();
   void slotAlbumSelected( const KURL &url );
   void slotImageFormatChanged(const TQString &string);

private:
 
   KIPI::Interface    *m_interface;
   TQImage              m_qimageScanned;

   TQPushButton        *m_addNewAlbumButton;
   TQPushButton        *m_helpButton;

   TDEConfig            *m_config;

   TQString             m_newDir;
   TQString             m_ImagesFilesSort;

   KIPI::UploadWidget* m_uploadPath;

   KIPIPlugins::KPAboutData *m_about; 

   KIntNumInput       *m_imageCompression;

   TQComboBox          *m_imagesFormat;

   TQLineEdit          *m_FileName;

   TQTextEdit          *m_CommentsEdit;

   TQLabel             *m_ImageComments;
   TQLabel             *m_imageLabel;
   TQLabel             *m_labelImageFormat;
   TQLabel             *m_ImageFileName;
   TQLabel             *m_preview;

   TQFrame             *page_setupImageOptions;
   TQFrame             *page_setupAlbumsList;

   KSqueezedTextLabel *m_AlbumComments;
   KSqueezedTextLabel *m_AlbumCollection;
   KSqueezedTextLabel *m_AlbumDate;
   KSqueezedTextLabel *m_AlbumItems;

private:
 
   TQString extension(const TQString& imageFormat);
   bool TQImageToTiff(const TQImage& image, const TQString& dst);
   void setupImageOptions(void);
   void setupAlbumsList(void);
   void writeSettings(void);
   void readSettings(void);
};

}  // NameSpace KIPIAcquireImagesPlugin

#endif  // ACQUIREIMAGEDIALOG_H
