//////////////////////////////////////////////////////////////////////////////
//
//    Copyright (C) 2006 Jesper Pedersen <blackie at kde.org>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Street, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef COMPAREOPERATION_H
#define COMPAREOPERATION_H

namespace KIPIFindDupplicateImagesPlugin
{
class CompareOperation
{
public:
    CompareOperation() :m_stopRequested( false ) {}
    virtual TQDict < TQPtrVector < TQFile > > compare( const TQStringList& fileList ) = 0;
    void stopPlease() { m_stopRequested = true; }

protected:
    bool m_stopRequested;
};

}

#endif /* COMPAREOPERATION_H */

