/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2007-16-07
 * Description : a kipi plugin to export images to Picasa web service
 *
 * Copyright (C) 2007-2008 by Vardhman Jain <vardhman at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef PICASAWEBLOGIN_H
#define PICASAWEBLOGIN_H

// TQt includes.

#include <tqdialog.h>

class TQLabel;
class TQLineEdit;

namespace KIPIPicasawebExportPlugin
{

class PicasawebLogin : public TQDialog
{
    TQ_OBJECT
  

public:

    PicasawebLogin(TQWidget* parent, const TQString& header, const TQString& _name=TQString(),
                   const TQString& _passwd=TQString());
    ~PicasawebLogin();

    TQString name()     const;
    TQString password() const;
    TQString username() const;
    void setUsername(const TQString&);
    void setPassword(const TQString&);

private:

    TQLabel*    m_headerLabel;
    TQLineEdit* m_nameEdit;
    TQLineEdit* m_passwdEdit;
};

} // namespace KIPIPicasawebExportPlugin

#endif // PICASAWEBLOGIN_H
