/***************************************************************************
                          kbswitchintf.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbswitchintf.h"

KBSwitchIntf::KBSwitchIntf(TQObject *parent, KBConfig *conf)
  : TQObject(parent, "KBSwitchIntf"), DCOPObject("KBSwitchIntf")
{
  m_kbconf = conf;
}

KBSwitchIntf::~KBSwitchIntf(){
}

int KBSwitchIntf::getNumKbdGroups()
{
  return m_kbconf->groupCount();
}

ASYNC KBSwitchIntf::selectNextGroup()
{
  emit nextGroupSelected();
}

ASYNC KBSwitchIntf::selectGroup(int groupno)
{
  emit groupSelected(groupno);
}

TQStringList KBSwitchIntf::getGroupNames()
{
  TQStringList result;
  for (int i = 0; i < m_kbconf->groupCount(); i++)
    result.append(m_kbconf->getGroup(i)->getName());
  return result;
}

#include "kbswitchintf.moc"
