/***************************************************************************
 *   Copyright (C) 2004 by Leonid Zeitlin                                  *
 *   lz@europe.com                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef WINDOWCLASSWATCHER_H
#define WINDOWCLASSWATCHER_H

#include "windowwatcher.h"
#include <tqmap.h>

class TQString;

/**
This class watcher for active window changes and keeps a group per window class

@author Leonid Zeitlin
*/
class WindowClassWatcher : public WindowWatcher {
  TQ_OBJECT
private:
  typedef TQMap<WId, TQString> WinClassMap;
  WinClassMap m_win_class_map;
  struct KBClassInfo  {
    int groupno;
    int next_groupno;
    int refcount;   
    KBClassInfo() : refcount(0) {} 
  };
  typedef TQMap<TQString, KBClassInfo> ClassGroupMap;
  ClassGroupMap m_class_group_map;
  ClassGroupMap::Iterator m_active_class;
  TQString getWindowClass(WId id);
protected:
  virtual void windowAdded(WId id);
  virtual void windowRemoved(WId id);
  virtual void activeWindowChanged(WId id);
public:
  WindowClassWatcher(KBConfig *kbconf, TQObject *parent = 0, const char *name = 0);
  ~WindowClassWatcher();
  virtual void changeGroup(int groupno, int next_groupno);
  virtual void reset();
};

#endif
