//
// C++ Implementation:
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//


#include "kmfprotocollistview.h"

// TQt includes
#include <tqlistview.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>
#include <tqcombobox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqwidgetstack.h>
#include <tqtextedit.h>
#include <tqtimer.h>


// KDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdelistview.h>
#include <kcombobox.h>
#include <tdepopupmenu.h>
#include <kiconloader.h>
#include <kinputdialog.h>
#include <knuminput.h>

// Project includes
#include "../core/kmfprotocolcategory.h"
#include "../core/kmfprotocol.h"
#include "../core/kmfprotocollibrary.h"
#include "../core/kmfprotocolusage.h"
#include "../core/kmfnetzone.h"
#include "../core/kmfnethost.h"
#include "../kmfwidgets/kmflistviewitem.h"
#include "../kmfwidgets/kmfchecklistitem.h"
namespace KMF {
KMFProtocolListView::KMFProtocolListView ( TQWidget* parent, const char* name, WFlags fl )
		: KMyFirewallProtocolListView ( parent,name,fl ) {
	m_reloading = false;
	loadProtocols();
	connect( m_lv_protocols, TQ_SIGNAL( pressed( TQListViewItem* ) ),
		this, TQ_SLOT( slotNewProtocolSelected( TQListViewItem* ) ) );
	
}

KMFProtocolListView::~KMFProtocolListView() {}

/*$SPECIALIZATION$*/
void KMFProtocolListView::setHost( KMFNetHost* host ) {
	setEnabled( true );
	
 	TQValueList<KMFProtocol*>& allProts = KMFProtocolLibrary::instance()->allProtocols();
	TQValueList<KMFProtocol*>::iterator it;
	for( it = allProts.begin(); it != allProts.end(); ++it ) {
/*	TQPtrListIterator<KMFProtocol> it( *KMFProtocol::protocolLibrary() );
	while ( it.current() ) {*/
		KMFProtocol * prot = *it;
		TQListViewItem *qitem = m_lv_protocols->findItem( prot->name(), 0 );
		if ( ! qitem ) {
			kdDebug() << "No item found for protocol: " << prot->name() << endl;
		}
		
		KMFCheckListItem *item = dynamic_cast<KMFCheckListItem*>( qitem );
		if ( ! item ) {
			kdDebug() << "Item is no KMFCheckListItem" << endl;
		}
		
		if ( host->findProtocolUsageByProtocolUuid( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( true );
		}
		if ( host->protocolInherited( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( false );
		}
		if ( ! host->findProtocolUsageByProtocolUuid( prot->uuid() )  && ! host->protocolInherited( prot->uuid() ) ) {
			item->setOn( false );
			item->setEnabled( true );
		}
	}
}
void KMFProtocolListView::setZone( KMFNetZone* zone ) {
	setEnabled( true );
	TQValueList<KMFProtocol*>& allProts = KMFProtocolLibrary::instance()->allProtocols();
	TQValueList<KMFProtocol*>::iterator it;
	for( it = allProts.begin(); it != allProts.end(); ++it ) {
		KMFProtocol * prot = *it;
		TQListViewItem *qitem = m_lv_protocols->findItem( prot->name(), 0 );
		if ( ! qitem ) {
			kdDebug() << "No item found for protocol: " << prot->name() << endl;
		}
		
		KMFCheckListItem *item = dynamic_cast<KMFCheckListItem*>( qitem );
		if ( ! item ) {
			kdDebug() << "Item is no KMFCheckListItem" << endl;
		}
		
		if ( zone->findProtocolUsageByProtocolUuid( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( true );
		}
		if ( zone->protocolInherited( prot->uuid() ) ) {
			item->setOn( true );
			item->setEnabled( false );
		}
		if ( 	! zone->findProtocolUsageByProtocolUuid( prot->uuid() )  && 
				! zone->protocolInherited( prot->uuid() ) ) {
			item->setOn( false );
			item->setEnabled( true );
		}
	}
}

void KMFProtocolListView::loadProtocols() {
	kdDebug() << "KMFProtocolListView::loadProtocols(" << endl;
	
	m_reloading = true;
	TQListViewItemIterator listViewIt( m_lv_protocols );
	while ( listViewIt.current() ) {
		TQListViewItem * qitem = listViewIt.current();
		++listViewIt;
		KMFCheckListItem * item = 0;
		item = dynamic_cast<KMFCheckListItem*> ( qitem );
		if( item && item->protocolUsage() ) {
			item->protocolUsage()->deleteLater();
		}
		
	}
	m_lv_protocols->clear();
	
	
	setEnabled( false );
	TQValueList<KMFProtocol*>& allProts = KMFProtocolLibrary::instance()->allProtocols();
	TQValueList<KMFProtocol*>::iterator it;
	for( it = allProts.begin(); it != allProts.end(); ++it ) {
		KMFProtocol * prot = *it;
/*		disconnect( prot, TQ_SIGNAL( destroyed( TQObject* ) ),
			this, TQ_SLOT( slotOnProtocolDeleted( TQObject* ) ) );
		connect( prot, TQ_SIGNAL( destroyed( TQObject* ) ),
			this, TQ_SLOT( slotOnProtocolDeleted( TQObject* ) ) );*/
		
		KMFProtocolUsage *protUsage = prot->createUsage();
		protUsage->setProtocol( prot );
		
			

		
		TQString cat = prot->category()->name();
		TQListViewItem *parentItem = m_lv_protocols->findItem( cat, 0 );
		
		if ( ! parentItem ) {
			KMFListViewItem *newParentItem = new KMFListViewItem( m_lv_protocols, 0, prot->category() );
			newParentItem->setText( 0, cat );
			newParentItem->loadNetfilterObject( prot->category() );
			newParentItem->setOpen( true );
			parentItem = newParentItem;
		}
		
		KMFCheckListItem *item = new KMFCheckListItem( parentItem, 0 , prot->name() , TQCheckListItem::CheckBox, protUsage );
		item->setText( 0, prot->name() );
		// item->setText( 1, prot->uuid().toString() );
	}
	m_reloading = false;
}

void KMFProtocolListView::slotOnProtocolDeleted( TQObject* ) {
	if ( m_reloading ) {
		return;
	}
	// loadProtocols();
}

void KMFProtocolListView::slotNewProtocolSelected( TQListViewItem* qitem ) {
	if ( KMFCheckListItem * item = dynamic_cast<KMFCheckListItem*> ( qitem ) ) {
		emit sigProtocolClicked( item->protocolUsage(), item->isOn() );
	} else if ( KMFListViewItem * item = dynamic_cast<KMFListViewItem*> ( qitem ) ){
		emit sigProtocolCategoryClicked( item->protocolCategory() );
	}
}

}


#include "kmfprotocollistview.moc"

