/***************************************************************************
                          mymoneytemplate.h  -  description
                             -------------------
    begin                : Sat Aug 14 2004
    copyright            : (C) 2004 by Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYMONEYTEMPLATE_H
#define MYMONEYTEMPLATE_H

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqdom.h>
class TQFile;
class TQListViewItem;

// ----------------------------------------------------------------------------
// TDE Includes

#include <kurl.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneyaccount.h>
#include <kmymoney/mymoneyfile.h>

/**
  * @author Thomas Baumgart
  */

/**
  * This class represents an account template handler. It is capable
  * to read an XML formatted account template file and import it into
  * the current engine. Also, it can save the current account structure
  * of the engine to an XML formatted template file.
  */
class MyMoneyTemplate
{
public:
  MyMoneyTemplate();
  MyMoneyTemplate(const KURL& url);
  ~MyMoneyTemplate();

  bool loadTemplate(const KURL& url);
  bool saveTemplate(const KURL& url);
  bool importTemplate(void(*callback)(int, int, const TQString&));
  bool exportTemplate(void(*callback)(int, int, const TQString&));

  const TQString& title(void) const { return m_title; }
  const TQString& shortDescription(void) const { return m_shortDesc; }
  const TQString& longDescription(void) const { return m_longDesc; }

  void hierarchy(TQMap<TQString, TQListViewItem*>& list);

protected:
  bool loadDescription(void);
  bool createAccounts(MyMoneyAccount& parent, TQDomNode account);
  bool setFlags(MyMoneyAccount& acc, TQDomNode flags);
  bool saveToLocalFile(TQFile* qfile);
  bool addAccountStructure(TQDomElement& parent, const MyMoneyAccount& acc);
  bool hierarchy(TQMap<TQString, TQListViewItem*>& list, const TQString& parent, TQDomNode account);

  /**
    * This method is used to update the progress information. It
    * checks if an appropriate function is known and calls it.
    *
    * For a parameter description see KMyMoneyView::progressCallback().
    */
  void signalProgress(int current, int total, const TQString& = "");

private:
  TQDomDocument    m_doc;
  TQDomNode        m_accounts;
  TQString         m_title;
  TQString         m_shortDesc;
  TQString         m_longDesc;
  KURL            m_source;
  void            (*m_progressCallback)(int, int, const TQString&);
  int             m_accountsRead;
};

#endif
