/***************************************************************************
                          command.h  -  description
                             -------------------
    begin                : Sun Jun 30 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef COMMAND_H
#define COMMAND_H

#include <tqstring.h>
#include "definitions.h"

/**
  *@author Alexander Wels.
  */
		/* Commands */

/*
		These constants represent the game's desire to send the IOs a command.
		SendCMD will convert them to the correct command for the current protocol.
*/

const int CMD_None							= 0x00000000;
const int CMD_Init							= 0x00000001;
const int CMD_NewGame					= 0x00000002;
const int CMD_Exit							= 0x00000003;
const int CMD_MoveNow					= 0x00000004;
const int CMD_Pause						= 0x00000005;
const int CMD_Resume						= 0x00000006;
const int CMD_Move							= 0x00000007;
const int CMD_Illegal					= 0x00000008;
const int CMD_Play_White				= 0x00000009;
const int CMD_Play_Black				= 0x0000000a;
const int CMD_Result_White			= 0x0000000b;
const int CMD_Result_Black			= 0x0000000c;
const int CMD_Result_Draw			= 0x0000000d;
const int CMD_Your_Time				= 0x0000000e;
const int CMD_Enemy_Time				= 0x0000000f;
const int CMD_Offer_Draw				= 0x00000010;
const int CMD_Ponder						= 0x00000011;
const int CMD_No_Pondering			= 0x00000012;
const int CMD_Book_Mode				= 0x00000013;
const int CMD_Out_Of_Book			= 0x00000014;
const int CMD_Check_Book				= 0x00000015;
const int CMD_Retract_Move			= 0x00000016;
const int CMD_Hint							= 0x00000017;
const int CMD_Listen						= 0x00000018;
const int CMD_Play							= 0x00000019;
const int CMD_Tell_User				= 0x0000001a;
const int CMD_Tell_User_Error		= 0x0000001b;
const int CMD_White_Resign			= 0x0000001c;
const int CMD_Black_Resign			= 0x0000001d;
const int CMD_White_Called_Flag	= 0x0000001e;
const int CMD_Black_Called_Flag	= 0x0000001f;
const int CMD_Set_Depth				= 0x00000020;
const int CMD_Set_Board				= 0x00000021;
const int CMD_Set_Difficulty		= 0x00000022;
const int CMD_Tell_Opponent		= 0x00000023;
const int CMD_Tell_Others			= 0x00000024;
const int CMD_Tell_All					= 0x00000025;
const int CMD_Tell_ICS					= 0x00000026;
const int CMD_Set_Name					= 0x00000028;

/* Engine Specific */
const int CMD_UCI_Hint					= 0x00100001;
const int CMD_Send_SIGTERM			= 0x00100002;
const int CMD_Send_SIGINT				= 0x00100003;

/* Internet specific commands */
const int CMD_Reject_Draw				= 0x01000001;
const int CMD_Reset_Server			= 0x01000002;
const int CMD_Examine_Forward		= 0x01000003;
const int CMD_Examine_Backward	= 0x01000004;
const int CMD_Lost_Contact			= 0x01000005;
const int CMD_Bad_Login					= 0x01000006;
const int CMD_Toggle_Seek				= 0x01000007;
const int CMD_Assess						= 0x01000008;
const int CMD_Player_Finger			= 0x01000009;
const int CMD_Player_History		= 0x0100000a;
const int CMD_Add_Friend				= 0x0100000b;
const int CMD_Ignore_Player			= 0x0100000c;
const int CMD_Start_Match				= 0x0100000d;

/* These commands are from Match to Core ONLY */
const int CMD_New_Players				= 0x02000001;

/* These commands are sent to ICS Related Widgets */
const int CMD_Add_Sought_Match	= 0x03000001;
const int CMD_Show_Sought_List	= 0x03000002;
const int CMD_Hide_Sought_List	= 0x03000003;
const int CMD_Set_Input					= 0x03000004;
const int CMD_Set_Src_Tell			= 0x03000005;
const int CMD_Set_Src_Channel		= 0x03000006;
const int CMD_Append_To_Console	= 0x03000007;
const int CMD_Send_To_ICS				= 0x03000008;

class Command
{

protected:
  int white_time; // Centiseconds
  int black_time; // Centiseconds
  struct ChessMove move;
  int command;
  int id;
  TQString data; // Generic String... used for ICS and FEN, etc.

public:
  Command( int ID, int Command );
  Command( int ID, int Command, TQString Data );
  Command( int ID, int Command, int WhiteTime, int BlackTime, struct ChessMove Move );
  Command( int ID, int Command, int WhiteTime, int BlackTime, struct ChessMove Move, TQString Data );
  Command( int ID, int Command, int WhiteTime, int BlackTime, TQString Data );
  Command();
  ~Command();
  void clear( void );

	/* Static Public Members */
	static void clearMove( struct ChessMove *Move );

	/* Inline Members */
  int getWhiteTime( void )
  {
    return white_time;
  }

  int getBlackTime( void )
  {
    return black_time;
  }

  struct ChessMove& getMove( void )
  {
    return move;
  }

  int getID( void )
  {
    return id;
  }

  int getCommand( void )
  {
    return command;
  }

  TQString& getData( void )
  {
    return data;
  }

  void setWhiteTime( int time )
  {
    white_time = time;
  }

  void setBlackTime( int time )
  {
    black_time = time;
  }

  void setMove( struct ChessMove &NewMove )
  {
    move = NewMove;
  }

  void setID( int NewID )
  {
    id = NewID;
  }

  void setCommand( int &NewCommand )
  {
    command = NewCommand;
  }

  void setData( TQString &NewData )
  {
    data = NewData;
  }
};

#endif
