/***************************************************************************
                          match_param.h  -  description
                             -------------------
    begin                : Tue Jun 25 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MATCH_PARAM_H
#define MATCH_PARAM_H

/**
  *@author Troy Corbin Jr.
  */

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqpixmap.h>
#include <tqvaluelist.h>
#include <tqtimer.h>
#include "definitions.h"
#include "resource.h"

class match_param : public TQObject
{
   TQ_OBJECT
  

	private:
		resource							*myResource;
		TQStringList						PlayerNames;
		TQValueList<TQPixmap>		PlayerImages;

										/*
												This is used to keep the signal valuesChanged
												from triggering multiple times in a row.
										*/
		bool									TimerFlag;

		char									Type[4];
		TCPList								Time_White;
		TCPList								Time_Black;
		char									Strength[4];
		int										Variation;

	protected:
		void									initialize( void );
		void									lookupTCP( void );
		void									lookupNames( void );
		void									lookupImages( void );
		void									setTimer( void );

	public:
													match_param( resource *Rsrc=0 );
													match_param( resource*, const int &whiteType, const int &blackType );
													~match_param();

		char									type( const int &player )
															{ return Type[player]; }

		char									strength( const int &player )
															{ return Strength[player]; }

		TQPixmap								image( const char &player )
															{ return PlayerImages[player]; }

		TQString								name( const char &player )
															{ return PlayerNames[player]; }

		TCPList								time( const char &player );

		void									setType( const int &player, const char &type );

		void									setStrength( const int &player, const char &str )
															{ setTimer(); myResource->Strength[player] = Strength[player] = str; }

		void									setTime( const char &player, const TCPList &tcp );

		void									setName( const int &player, const TQString &name )
															{ PlayerNames[player] = name; }

		void									setVariation( const int variation );
		int										getVariation( void );

	public slots:
		void									slot_Timer( void );

	signals:
		void									valuesChanged( void );
};

#endif
