/***************************************************************************
                          notes.h  -  description
                             -------------------
    begin                : sob lis 16 2002
    copyright            : (C) 2002-2004 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KNOWIT_NOTES_H
#define KNOWIT_NOTES_H

#include <tqstring.h>
#include <tqpixmap.h>
#include <tqvaluelist.h>
#include <tqvaluevector.h>
#include <tqptrdict.h>
class TQTextStream;
class TQListViewItem;
class KURL;

class TNote;

class TNoteLink
{
public:
   enum {DescriptionLink, LinkDescription, LinkOnly, DescriptionOnly};
   TQString link;
   TQString description;
   TNoteLink()   {}
   TNoteLink(const TQString& s)   {link = s;}
   TNoteLink(const TQString& s1, const TQString& s2) {link = s1; description = s2;}
   int operator==(const TNoteLink& N) const   {return link == N.link &&
      description == N.description;}
   int operator!=(const TNoteLink& N) const   {return link != N.link ||
      description != N.description;}
   void save(TQTextStream& ts) const;
   void open() const;
   void openWith() const;
   TQString text(int fmt = DescriptionLink) const;
   TQPixmap icon() const;
   bool isLocalReference() const;
};


class TNotesCollection : public TQPtrDict<TNote> {
public:
   TQPixmap Pixmaps[4];
   TNotesCollection();
   ~TNotesCollection();
   void addNote(TQListViewItem* item);
   void addNote(TQListViewItem* item, const TQString& s);
   void removeNote(TQListViewItem* item);
   bool changeNote(TQListViewItem* item, const TQString& s);
   void clearNotes();
   void updateNotesView();
   bool modified;
   bool autoUpdate;
   const TQString& text(TQListViewItem* item);
};


class TNote {
private:
   TQValueList<TNoteLink> links;
   TNotesCollection* collection;
   bool saveHTMLBuf(TQTextStream& ts, TQValueVector<int>& depths,
      int flags = SaveAll);
   bool saveHTMLTocEntry(TQTextStream& ts, TQValueVector<int>& depths, int flags);
public:
   typedef enum {Empty, Text, EmptyParent, TextParent} State;
   enum {SaveCurrent = 0, SaveSubnotes = 0x0001, SaveAll = 0x0002, UseUTF8 = 0x0040,
         Enumerate = 0x0080, AddRule = 0x0100, Style = 0x0200, TOC = 0x0400};
   TQListViewItem* item;
   TQString text;
   bool isEmpty();
   bool contains(const TQString& sought, bool case_sensitive = false);
   bool change(const TQString& s);
   void destroy();
   void updateView();
   State state();
   void open(TQTextStream& ts);
   void save(TQTextStream& ts, bool current = false);
   bool saveHTML(const KURL& fname, const TQString& origname, const TQString& style,
      int flags = SaveAll);
   void addLink(const TQString& s);
   void addLink(const TNoteLink& l);
   int linkCount() const;
   const TNoteLink& link(int i) const;
   void removeLink(int i);
   void modifyLink(int i, const TQString& s);
   void modifyLink(int i, TNoteLink& l);
   void modifyLinkDescription(int i, const TQString& s);
   TNote(TQListViewItem* i, TNotesCollection* coll);
   TNote(TQListViewItem* i, TNotesCollection* coll, const TQString& s);
   ~TNote();
};
#endif

