/***************************************************************************
                          knutprintupsvar.cpp  -  description
                             -------------------
    begin                : St cec 3 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutprintupsvar.h"
#include "knutvardata.h"

#include <tdemessagebox.h>
#include <tdeglobal.h>
#include <kiconloader.h>

#include <tqgroupbox.h>
#include <tqscrollview.h>
#include <tqtooltip.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <tqpixmap.h>
#include <tqstring.h>



//#include <iostream>


// od verze 0.6.0  nebudeme vytvaret vlastni spojeni

KNutPrintUpsVar::KNutPrintUpsVar(KNutNet* const upsNet, const bool useDescription, TQWidget* parent,  const char* name, const bool modal )
: KDialogBase(Plain, i18n("Variables"),User1|Cancel,Ok, parent, name, modal, true), myUpsNet(upsNet){

  upsVarDef upsVar;
  upsICommDef upsIComm;
  dataVar pointerVar;
  dataList.clear();

  if (!upsNet) return;

  setButtonText(User1,i18n("Reload Vars"));
  setName( "knutprintupsvar" );
  setCaption( i18n("UPS variables") );

 //int error;  
 if (myUpsNet->getState() != KNutNet::Connected) {
    KNutVarData::showError (KNutNet::NotConnection);
    upsConnectOk = false;
    page=0;
    }
  else {
    upsConnectOk = true;
    countVars=myUpsNet->readNumberVars(KNutNet::AllVars);
    countRWVars=myUpsNet->readNumberVars(KNutNet::RWVars);
    countIComms=myUpsNet->readNumberComms();

    TDEIconLoader *loader = TDEGlobal::iconLoader();
    dirPixmap=loader->loadIcon ("folder_open",TDEIcon::Small,16);

    page = plainPage();
    TQHBoxLayout* upsVarsMainLayout = new TQHBoxLayout(page);

    table = new TDEListView(page);
    table->setRootIsDecorated(true);

    table->setAllColumnsShowFocus( true );
    table->setFullWidth ( true );

    table->addColumn( i18n("Name") );
    table->addColumn( i18n("Value") );
    if (useDescription)
      table->addColumn( i18n("Description") );
    table->setSorting (-1);  

    upsVarsMainLayout->addWidget(table);


    TDEListViewItem* myListItem;
    if (countIComms) {

      ICommList = new TDEListViewItem( table, i18n("Instant Commands"));
      ICommList->setOpen(true);

      for (int i=0; i<countIComms; i++) {
        myUpsNet->readIComm(i+1,upsIComm);

        myListItem = addListItem( ICommList,upsIComm.upsCommName,"");
        if ((!upsVar.upsDescription.isEmpty()) && useDescription)
          myListItem->setText(2,upsIComm.upsDescription);
       }
     }

    if (countRWVars) {
      RWVarsList = new TDEListViewItem( table, i18n("Read/Write Variables"));
      RWVarsList->setOpen(true);
      for (int i=0; i<countVars; i++) {
        myUpsNet->readVars(i+1,upsVar);

        if (!upsVar.upsVarType) {
          pointerVar.myName=upsVar.upsVarName;
          pointerVar.myValue = addListItem( RWVarsList,upsVar.upsVarName,upsVar.upsValue);

       if ((!upsVar.upsDescription.isEmpty()) && useDescription)
          pointerVar.myValue->setText(2,upsVar.upsDescription);

          dataList.push_back(pointerVar);
         }
       }
     }


    ROVarsList = new TDEListViewItem( table, i18n("Read Only Variables"));
    ROVarsList->setOpen(true);

    for (int i=0; i<countVars; i++) {
      myUpsNet->readVars(i+1,upsVar);
      if (upsVar.upsVarType) {

        pointerVar.myName=upsVar.upsVarName;
        pointerVar.myValue = addListItem( ROVarsList,upsVar.upsVarName,upsVar.upsValue);

       if ((!upsVar.upsDescription.isEmpty()) && useDescription)
          pointerVar.myValue->setText(2,upsVar.upsDescription);

       dataList.push_back(pointerVar);
       }
     }

    connect (this,TQ_SIGNAL(user1Clicked()),this,TQ_SLOT(slotReloadVars()));
    } // end else
  }



KNutPrintUpsVar::~KNutPrintUpsVar(){

  dataList.clear();
  if (page) delete page;
  }


void KNutPrintUpsVar::slotReloadVars (void) {
  upsVarDef upsVar;

  if (myUpsNet->getUpsValues(true) !=0)
    KNutVarData::showError (myUpsNet->getError());
  else {

    TQValueVector<dataVar>::const_iterator it;
    for (it = dataList.begin(); it != dataList.end(); it++) {
      myUpsNet->readVars((*it).myName, upsVar);
      (*it).myValue->setText (1, upsVar.upsValue);
      }
    }
  }

  TDEListViewItem* KNutPrintUpsVar::addListItem (TDEListViewItem* table, TQString varName, TQString value) {
  TDEListViewItem* myListItem;
  TDEListViewItem* helpListItem;
  TQString left;
  int n;

  myListItem = table;
  do {
    n = varName.find(".");
    if (n > 0) {
      left = varName.left(n);
      varName = varName.mid(n+1);
      if (!(helpListItem = existListItem( myListItem,left))) {
        myListItem = new TDEListViewItem( myListItem, left);
        myListItem->setOpen(true);
        }
      else myListItem = helpListItem;
      if (!myListItem->pixmap(0)) myListItem->setPixmap(0,dirPixmap);
      }
    else { // end part
      helpListItem = new TDEListViewItem( myListItem, varName, value);
      helpListItem->setOpen(true);
      return helpListItem;
      }
    } while (n > -1);
  return 0; // for compiler only  
  }


    TDEListViewItem* KNutPrintUpsVar::existListItem (TDEListViewItem* listItem, TQString name) {
    TDEListViewItem*  myItem;

    if (!(myItem = (TDEListViewItem *)listItem->firstChild())) return 0l;
    while (myItem) {
      if (myItem->text(0) == name) return myItem;
      myItem = (TDEListViewItem *)myItem->nextSibling(); 
      }
    return 0l;
    }

bool KNutPrintUpsVar::upsOk (void) { return upsConnectOk; }


#include "knutprintupsvar.moc"

