/*
 *  kis_cursor.h - part of KImageShop
 *
 *  Copyright (c) 1999 Matthias Elter <elter@kde.org>
 *  Copyright (c) 2004 Adrian Page <adrian@pagenet.plus.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __kis_cursor_h__
#define __kis_cursor_h__
#include <koffice_export.h>
class TQCursor;

class KRITACORE_EXPORT KisCursor
{

public:

    KisCursor();

    // Predefined TQt cursors.
    static TQCursor arrowCursor();         // standard arrow cursor
    static TQCursor upArrowCursor();       // upwards arrow
    static TQCursor crossCursor();         // crosshair
    static TQCursor waitCursor();          // hourglass/watch
    static TQCursor ibeamCursor();         // ibeam/text entry
    static TQCursor sizeVerCursor();       // vertical resize
    static TQCursor sizeHorCursor();       // horizontal resize
    static TQCursor sizeBDiagCursor();     // diagonal resize (/)
    static TQCursor sizeFDiagCursor();     // diagonal resize (\)
    static TQCursor sizeAllCursor();       // all directions resize
    static TQCursor blankCursor();         // blank/invisible cursor
    static TQCursor splitVCursor();        // vertical splitting
    static TQCursor splitHCursor();        // horziontal splitting
    static TQCursor pointingHandCursor();  // a pointing hand

    // Existing custom KimageShop cursors. Use the 'load' function for all new cursors.
    static TQCursor moveCursor();          // move tool cursor
    static TQCursor penCursor();           // pen tool cursor
    static TQCursor brushCursor();         // brush tool cursor
    static TQCursor airbrushCursor();      // airbrush tool cursor
    static TQCursor eraserCursor();        // eraser tool cursor
    static TQCursor fillerCursor();        // filler tool cursor
    static TQCursor pickerCursor();        // color picker cursor
    static TQCursor pickerPlusCursor();        // color picker cursor
    static TQCursor pickerMinusCursor();        // color picker cursor
    static TQCursor colorChangerCursor();  // color changer tool cursor
    static TQCursor selectCursor();        // select cursor
    static TQCursor zoomCursor();          // zoom tool cursor
    static TQCursor handCursor();          // hand tool cursor
    static TQCursor openHandCursor();      // Pan tool cursor
    static TQCursor closedHandCursor();    // Pan tool cursor
    static TQCursor rotateCursor();    // Transform tool cursor

    // Load a cursor from an image file. The image should have an alpha channel
    // and will be converted to black and white on loading. Any format loadable by
    // TQImage can be used.
    static TQCursor load(const TQString & imageFilename, int hotspotX = -1, int hotspotY = -1);
};
#endif // __kis_cursor_h__
