/* This file is part of the KDE project
   Copyright (C) 2005 Christian Nitschkowski <segfault_ii@web.de>
   Copyright (C) 2005 Jaroslaw Staniek <js@iidea.pl>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KEXIDBLABEL_H
#define KEXIDBLABEL_H

#include <tqimage.h>
#include <tqlabel.h>

#include <kpixmap.h>

#include "../kexiformdataiteminterface.h"
#include "../kexidbtextwidgetinterface.h"
#include <widget/utils/kexidisplayutils.h>

class TQPainter;
class TQTimer;
class KexiDBInternalLabel;

//! @short An extended, data-aware, read-only text label.
/*! It's text may have a drop-shadow.

 @author Christian Nitschkowski, Jaroslaw Staniek
*/
class KEXIFORMUTILS_EXPORT KexiDBLabel : public TQLabel, protected KexiDBTextWidgetInterface, public KexiFormDataItemInterface {
		TQ_OBJECT
  
		TQ_PROPERTY( TQString dataSource READ dataSource WRITE setDataSource DESIGNABLE true )
		TQ_PROPERTY( TQCString dataSourceMimeType READ dataSourceMimeType WRITE setDataSourceMimeType DESIGNABLE true )
		TQ_PROPERTY( bool shadowEnabled READ shadowEnabled WRITE setShadowEnabled DESIGNABLE true )
		TQ_OVERRIDE( TQPixmap pixmap DESIGNABLE false )
		TQ_OVERRIDE( bool scaledContents DESIGNABLE false )
//		TQ_OVERRIDE( TQColor paletteForegroundColor READ paletteForegroundColor WRITE setPaletteForegroundColor DESIGNABLE true )
		TQ_PROPERTY( TQColor frameColor READ frameColor WRITE setFrameColor DESIGNABLE true )

	public:
		KexiDBLabel( TQWidget *parent, const char *name = 0, WFlags f = 0 );
		KexiDBLabel( const TQString& text, TQWidget *parent, const char *name = 0, WFlags f = 0 );
		virtual ~KexiDBLabel();

		inline TQString dataSource() const { return KexiFormDataItemInterface::dataSource(); }
		inline TQCString dataSourceMimeType() const { return KexiFormDataItemInterface::dataSourceMimeType(); }

		virtual TQVariant value();

		bool shadowEnabled() const;

		virtual void setInvalidState( const TQString& displayText );

		virtual bool valueIsNull();

		virtual bool valueIsEmpty();

		//! always true
		virtual bool isReadOnly() const;

		virtual TQWidget* widget();

		//! always false
		virtual bool cursorAtStart();

		//! always false
		virtual bool cursorAtEnd();

		virtual void clear();

		//! used to catch setIndent(), etc.
		virtual bool setProperty ( const char * name, const TQVariant & value );

		virtual const TQColor& frameColor() const;

//		const TQColor & paletteForegroundColor() const;

	public slots:
		//! Sets the datasource to \a ds
		inline void setDataSource( const TQString &ds ) { KexiFormDataItemInterface::setDataSource( ds ); }

		inline void setDataSourceMimeType(const TQCString &ds) { KexiFormDataItemInterface::setDataSourceMimeType(ds); }

		virtual void setText( const TQString& text );

		/*! Enable/Disable the shadow effect.
		 KexiDBLabel acts just like a normal TQLabel when shadow is disabled. */
		void setShadowEnabled( bool state );

		virtual void setPalette( const TQPalette &pal );

		virtual void setFrameColor(const TQColor& color);

//		void setPaletteForegroundColor( const TQColor& color );

	protected slots:
		//! empty
		virtual void setReadOnly( bool readOnly );
		void updatePixmap();

	protected:
		void init();
		virtual void setColumnInfo(KexiDB::QueryColumnInfo* cinfo);
		virtual void paintEvent( TQPaintEvent* );
		virtual void resizeEvent( TQResizeEvent* e );

		//! Sets value \a value for a widget.
		virtual void setValueInternal( const TQVariant& add, bool removeOld );

		virtual void fontChange( const TQFont& font );
		virtual void styleChange( TQStyle& style );
		virtual void enabledChange( bool enabled );

		virtual void paletteChange( const TQPalette& oldPal );
		virtual void frameChanged();
		virtual void showEvent( TQShowEvent* e );

		//! Reimplemented to paint using real frame color instead of froeground. 
		//! Also allows to paint more types of frame.
		virtual void drawFrame( TQPainter * );

		void updatePixmapLater();

		class Private;
		Private *d;
};

#endif
