/* This file is part of the KDE project
   Copyright (C) 2002, Dirk Schnberger <dirk.schoenberger@sz-online.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef AIELEMENT_H
#define AIELEMENT_H

// #include <tqvaluelist.h>
#include <tqvaluevector.h>

class TQString;
class TQCString;

/**
  *@author 
  */

class AIElement {
public:
    enum Type {
	Invalid,
//	List,
	String,
	Int,
  UInt,
	Double,
	CString,
  // Custom Types
  Operator,
  Reference,
  ElementArray,
  Block,
  ByteArray,
  Byte
    };

    AIElement();
    ~AIElement();
    AIElement( const AIElement& );
    AIElement( const TQString&, Type type = String );
    AIElement( const TQCString& );
    AIElement( const char* );
//    AIElement( const TQValueList<AIElement>& );
    AIElement( const TQValueVector<AIElement>&, Type type = ElementArray);
    AIElement( int );
    AIElement( uint );
    AIElement( double );
    AIElement( const TQByteArray& );
    AIElement( uchar );

    AIElement& operator= ( const AIElement& );
    bool operator==( const AIElement& ) const;
    bool operator!=( const AIElement& ) const;

    Type type() const;
    const char* typeName() const;

    bool canCast( Type ) const;
    bool cast( Type );

    bool isValid() const;

    void clear();

    const TQString toString() const;
    const TQCString toCString() const;
    int toInt( bool * ok=0 ) const;
    uint toUInt( bool * ok=0 ) const;
    double toDouble( bool * ok=0 ) const;
//    const TQValueList<AIElement> toList() const;
    const TQValueVector<AIElement> toElementArray() const;
    const TQValueVector<AIElement> toBlock() const;

    // Custom types
    const TQString toReference() const;
    const TQString toOperator() const;
    const TQByteArray toByteArray() const;
    uchar toByte( bool * ok=0 ) const;

//    TQValueListConstIterator<AIElement> listBegin() const;
//    TQValueListConstIterator<AIElement> listEnd() const;
    TQString& asString();
    TQCString& asCString();
    int& asInt();
    uint& asUInt();
    double& asDouble();
//    TQValueList<AIElement>& asList();
    TQValueVector<AIElement>& asElementArray();
    TQValueVector<AIElement>& asBlock();

    // Custom types
    TQString& asReference();
    TQString& asToken();
    TQByteArray& asByteArray();
    uchar& asByte();

    static const char* typeToName( Type typ );
    static Type nameToType( const char* name );

private:
    void detach();

    class Private : public TQShared
    {
    public:
        Private();
        Private( Private* );
        ~Private();

        void clear();

        Type typ;
        union
        {
	    uint u;
	    int i;
	    double d;
      uchar b;
	    void *ptr;
        } value;
    };

    Private* d;
};

inline AIElement::Type AIElement::type() const
{
    return d->typ;
}

inline bool AIElement::isValid() const
{
    return (d->typ != Invalid);
}

#endif
