/* This file is part of the KDE project
   Copyright (C) 2002 Laurent Montel <lmontel@mandrakesoft.com>
   Copyright (c) 2003 Lukas Tinkl <lukas@kde.org>
   Copyright (c) 2003 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OOUTILS_H
#define OOUTILS_H

#include <tqstring.h>
#include <KoFilterChain.h>
class TQColor;
class TQDomElement;
class KoStyleStack;
class TQDomDocument;
class KZip;

class ooNS {
public:
    static const char* const office;
    static const char* const style;
    static const char* const text;
    static const char* const table;
    static const char* const draw;
    static const char* const presentation;
    static const char* const fo;
    static const char* const xlink;
    static const char* const number;
    static const char* const svg;
    static const char* const dc;
    static const char* const meta;
    static const char* const config;
};

namespace OoUtils
{
    TQString expandWhitespace(const TQDomElement& tag);

    bool parseBorder(const TQString & tag, double * width, int * style, TQColor * color);

    ///////// Paragraph properties /////////

    // Convert fo:margin-left, fo:margin-right and fo:text-indent to <INDENTS>
    void importIndents( TQDomElement& parentElement, const KoStyleStack& styleStack );

    // Convert fo:line-height, style:line-height-at-least and style:line-spacing to <LINESPACING>
    void importLineSpacing( TQDomElement& parentElement, const KoStyleStack& styleStack );

    // Convert fo:margin-top and fo:margin-bottom to <OFFSETS>
    void importTopBottomMargin( TQDomElement& parentElement, const KoStyleStack& styleStack );

    // Convert style:tab-stops to <TABULATORS>
    void importTabulators( TQDomElement& parentElement, const KoStyleStack& styleStack );

    // Convert fo:border* to <*BORDER>
    void importBorders( TQDomElement& parentElement, const KoStyleStack& styleStack );

    /////////// Text properties ///////////

    // From style:text-underline to kword/kpresenter's underline/underlinestyleline
    void importUnderline( const TQString& text_underline, TQString& underline, TQString& styleline );

    // From style:text-position (for subscript/superscript)
    // to kword/kpresenter's value/relativetextsize
    void importTextPosition( const TQString& text_position, TQString& value, TQString& relativetextsize );

    void createDocumentInfo(TQDomDocument &_meta, TQDomDocument & docinfo);
    KoFilter::ConversionStatus loadAndParse(const TQString& filename, TQDomDocument& doc, KZip * m_zip);
    KoFilter::ConversionStatus loadAndParse(const TQString& filename, TQDomDocument& doc, KoStore *m_store );

    /// Load an OASIS thumbnail
    KoFilter::ConversionStatus loadThumbnail( TQImage& thumbnail, KZip * m_zip );

    // Internal
    KoFilter::ConversionStatus loadAndParse(TQIODevice* io, TQDomDocument& doc, const TQString & fileName);
}

#endif /* OOUTILS_H */
