#include "KPrTextPreview.h"

#include <KoGlobal.h>

#include <tqpainter.h>
#include <tqfont.h>

KPrTextPreview::KPrTextPreview( TQWidget* parent, const char* name )
    : TQFrame( parent, name ),
      shadowDirection( SD_LEFT_BOTTOM ),
      shadowDistance( 0 ),
      angle( 0 )
{
    setBackgroundColor( white );
    setFrameStyle( NoFrame );
}

void KPrTextPreview::drawContents( TQPainter* painter )
{
    TQFont font(KoGlobal::defaultFont().family(), 30, TQFont::Bold);
    TQFontMetrics fm( font );

    TQRect br = fm.boundingRect( "KOffice" );
    int pw = br.width();
    int ph = br.height();
    TQRect r = br;
    int textYPos = -r.y();
    int textXPos = -r.x();
    br.moveTopLeft( TQPoint( -br.width() / 2, -br.height() / 2 ) );
    r.moveTopLeft( TQPoint( -r.width() / 2, -r.height() / 2 ) );

    int x = r.left() + textXPos;
    int y = r.top() + textYPos;
    int sx = 0, sy = 0;

    switch ( shadowDirection )
    {
    case SD_LEFT_UP:
    {
        sx = x - shadowDistance;
        sy = y - shadowDistance;
    } break;
    case SD_UP:
    {
        sx = x;
        sy = y - shadowDistance;
    } break;
    case SD_RIGHT_UP:
    {
        sx = x + shadowDistance;
        sy = y - shadowDistance;
    } break;
    case SD_RIGHT:
    {
        sx = x + shadowDistance;
        sy = y;
    } break;
    case SD_RIGHT_BOTTOM:
    {
        sx = x + shadowDistance;
        sy = y + shadowDistance;
    } break;
    case SD_BOTTOM:
    {
        sx = x;
        sy = y + shadowDistance;
    } break;
    case SD_LEFT_BOTTOM:
    {
        sx = x - shadowDistance;
        sy = y + shadowDistance;
    } break;
    case SD_LEFT:
    {
        sx = x - shadowDistance;
        sy = y;
    } break;
    }

    painter->save();

    painter->setViewport( ( width() - pw ) / 2, ( height() - ph ) / 2, width(), height() );

    TQWMatrix m, mtx;
    mtx.rotate( angle );
    m.translate( pw / 2, ph / 2 );
    m = mtx * m;

    painter->setWorldMatrix( m );
    painter->setFont( font );

    if ( shadowDistance > 0 ) {
	painter->setPen( shadowColor );
	painter->drawText( sx, sy, TQString("KOffice") );
    }
    painter->setPen( blue );
    painter->drawText( x, y, TQString("KOffice") );

    painter->restore();
}
#include "KPrTextPreview.moc"
