/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef _KO_TAB_PALETTE_
#define _KO_TAB_PALETTE_

#include <tqdockwindow.h>
#include <ktabwidget.h>

#include "kopalette.h"

class KoView;
class TQWidget;



/**
 * This is a palette with a tabwidget. It supports
 * reorganzing the pages and moving the pages to other
 * palettes with drag and drop,
 *
 */
class KoTabPalette : public KoPalette {

TQ_OBJECT
  

public:

    KoTabPalette(TQWidget * parent, const char * name);
    virtual ~KoTabPalette();

public:
    virtual void resetFont();
    virtual void plug(TQWidget * widget, const TQString & name, int position = -1);
    virtual void unplug(const TQWidget * widget);
    void showPage(TQWidget *w);
    void makeVisible(bool v);
    virtual void hidePage(TQWidget * w);
    int indexOf(TQWidget *w);
    bool isHidden(TQWidget *w);
    virtual void togglePageHidden(TQWidget *w);

private:

    KTabWidget * m_page;

    TQMap<TQWidget*, int> m_hiddenPages;
};

#endif //_KO_TAB_PALETTE_
