/*
 * Kivio - Visual Modelling and Flowcharting
 * Copyright (C) 2000 theKompany.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "tkcombobox.h"

#include <tqlistbox.h>
#include <tqpainter.h>
#include <tqstyle.h>
#include <tqdrawutil.h>

#include <tdeapplication.h>

TKComboBox::TKComboBox(TQWidget* parent, const char* name)
: TQComboBox(false,parent,name)
{
}


TKComboBox::TKComboBox( bool isEditable, TQWidget* parent, const char* name )
: TQComboBox(isEditable,parent,name)
{
}

TKComboBox::~TKComboBox()
{
}

void TKComboBox::paintEvent(TQPaintEvent*)
{
  TQRect r;
  if (editable()){
#ifdef __GNUC__
#warning "Left out for now, lacking a style expert (Werner)"
#endif
    //r = TQRect( style().comboButtonRect( 0, 0, width(), height() ) );
    r = TQRect(4, 2, width()-height()-2, height()-4);
  } else {
    r = TQRect(4, 2, width()-height()-2, height()-4);
  }
  int by = 2;
  int bx = r.x() + r.width();
  int bw = width() - bx - 2;
  int bh = height()-4;

  TQPainter p( this );
  const TQColorGroup& g = colorGroup();

  TQRect fr(2,2,width()-4,height()-4);

  if ( hasFocus()) {
    p.fillRect( fr, g.brush( TQColorGroup::Highlight ) );
  } else {
    p.fillRect( fr, g.brush( TQColorGroup::Base ) );
  }

  TQRect r1(1,1,width()-1,height()-1);
  qDrawShadePanel( &p, r1, g, true, 1 );

  static const char* arrow_down[] = {
  "7 7 2 1",
  "X c Gray0",
  "  c None",
  "XXXXXXX",
  "XXXXXXX",
  "       ",
  "XXXXXXX",
  " XXXXX ",
  "  XXX  ",
  "   X   "};

  TQPixmap pixmap(arrow_down);


  style().drawControl( TQStyle::CE_PushButton, &p, this, TQRect( bx, by, bw, bh ), colorGroup() );
  style().drawItem( &p, TQRect( bx, by, bw, bh), AlignCenter, colorGroup(), isEnabled(), &pixmap, TQString() );

  if ( hasFocus()) {
    style().drawPrimitive( TQStyle::PE_FocusRect, &p, fr, g );
  }

  if (!editable()) {
    p.setClipRect(r);
    p.setPen( g.text() );
    p.setBackgroundColor( g.background() );

    if ( listBox()->item(currentItem()) ) {
      TQListBoxItem * item = listBox()->item(currentItem());
      const TQPixmap *pix = item->pixmap();
      TQString text = item->text();
      int x = r.x();
      if ( pix ) {
        p.drawPixmap( x, r.y() + ( r.height() - pix->height() ) / 2 +1, *pix );
        x += pix->width()+3;
      }
      if (!text.isEmpty())
        p.drawText( x, r.y(), r.width()-x, r.height(), AlignLeft|AlignVCenter|SingleLine, text );
    }
  }
  p.end();
}

void TKComboBox::activate()
{
  emit activated(currentItem());
}

#include "tkcombobox.moc"
