/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2007 Shintaro Matsuoka <shin@shoegazed.org>
*/

#ifndef DCCCOMMON_H
#define DCCCOMMON_H

#include <tqstring.h>

class TQObject;

namespace KNetwork
{
    class TDEServerSocket;
}

class Server;

class DccCommon
{
    public:
        // converts an IP text like "127.0.0.1" to a number.
        static TQString textIpToNumericalIp( const TQString& ipString );

        // converts a numerical IP text like "12345678" to a normal IP text.
        static TQString numericalIpToTextIp( const TQString& numericalIp );

        // returns the self IP following the setting.
        static TQString getOwnIp( Server* server = 0 );

        // creates an instance of KNetwork::ServerSocket following the DCC settings
        static KNetwork::TDEServerSocket* createServerSocketAndListen( TQObject* parent = 0, TQString* failedReason = 0, int minPort = 0, int maxPort = 0 );

        // returns the port number from a server socket
        static int getServerSocketPort( KNetwork::TDEServerSocket* serverSocket );

    private:
        DccCommon();
};

#endif  // DCCCOMMON_H
