/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2005 Peter Simonsson <psn@linux.se>
*/

#ifndef KONVERSATIONEMOTICON_H
#define KONVERSATIONEMOTICON_H

#include <tqstring.h>
#include <tqmap.h>


class TQFontMetrics;

namespace Konversation
{

    typedef TQMap<TQString, TQString> EmotIconMap;

    class EmotIcon
    {
        public:
            ~EmotIcon();
            static EmotIcon* self();

            static void changeTheme(const TQString& themeName);
            static TQString filter(const TQString& txt, const TQFontMetrics& fm);

        protected:
            EmotIcon();
            static EmotIcon* s_self;

            static TQString findIcon(const TQString& filename);

        private:
            TQString m_themeName;
            EmotIconMap m_emotIconMap;
    };

}
#endif
