/***************************************************************************
                          tabs.cpp  -  description
                             -------------------
    begin                : Die Mai 20 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tabs.h"
#include "krenameimpl.h"
#include "kmyhistorycombo.h"

// TQt includes
#include <tqlayout.h>
#include <tqsizepolicy.h> 
#include <tqtabwidget.h>

// TDE includes
#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <tdemenubar.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>
#include <tdestartupinfo.h>

tabs::tabs(KRenameImpl* impl, TQRect r, TQWidget *parent, const char *name )
    : TQDialog(parent,name)
{
    setIcon( BarIcon( "krename" ) );

    TQVBoxLayout* layout = new TQVBoxLayout( this, 6, 6 );
    TQHBoxLayout* buttons = new TQHBoxLayout( 0, 6, 6 );
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Expanding );
    
    tab = new TQTabWidget( this );
    finishButton = new KPushButton( i18n("&Finish"), this );
    finishButton->setIconSet( SmallIconSet( "go-last" ) );
    finishButton->setDefault( true );
    cancelButton = new KPushButton( i18n("&Cancel"), this );
    cancelButton->setIconSet( SmallIconSet( "button_cancel" ) );
    
    buttons->addItem( spacer );
    buttons->addWidget( finishButton );
    buttons->addWidget( cancelButton );
    
    layout->addWidget( tab );
    layout->addLayout( buttons );
    layout->setStretchFactor( tab, 2 );

    menuBar = new KMenuBar( this );
    layout->setMenuBar( menuBar );
    
    connect( cancelButton, TQ_SIGNAL( clicked() ), this, TQ_SLOT( close() ) );

    krename = impl ? impl : new KRenameImpl( this, menuBar, finishButton );

    connect( krename, TQ_SIGNAL( pageDone( TQWidget*, const TQString & ) ), this, TQ_SLOT( slotAddPage( TQWidget*, const TQString & ) ) );
    connect( krename, TQ_SIGNAL( showPage( int ) ), this, TQ_SLOT( slotShowPage( int ) ) );
    connect( krename, TQ_SIGNAL( enableFinish( bool ) ), this, TQ_SLOT( slotEnableFinish( bool ) ) );
    connect( tab, TQ_SIGNAL( currentChanged( TQWidget* ) ), this, TQ_SLOT( slotTabChanged() ) );
    
    if( impl ) 
    {
        krename->changeParent( this, menuBar, finishButton, r );
        krename->setWizardMode( false );
    } else 
        krename->setup( false );

    // Tell TDEStartupInfo that KRename has been loaded completly
    TDEStartupInfoId id;
    id.initId( kapp->startupId() );
    TDEStartupInfo::sendFinish( id );
}

tabs::~tabs()
{
}

void tabs::slotAddPage( TQWidget* page, const TQString & title )
{
    tab->addTab( page, title );
}

void tabs::slotShowPage( int page )
{
    tab->setCurrentPage( page - 1 );
}

void tabs::slotEnableFinish( bool b )
{
    finishButton->setEnabled( b );
}

void tabs::slotTabChanged()
{
    if( tab->currentPageIndex() == tab->count() - 1 )
    {
        krename->filename->setFocus();
        krename->filename->lineEdit()->selectAll();
    }
}

void tabs::keyPressEvent( TQKeyEvent *e )
{
    // ESC should not close KRename
    if( e->key() == TQt::Key_Escape )
        e->accept();
    else
        e->ignore();
}

#include "tabs.moc"
