/*
	mmessagedialog.h - A warning message dialog
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MMESSAGEDIALOG_H__
#define __MMESSAGEDIALOG_H__

#include "actions.h"

#include <kdialog.h>

class TQLCDNumber;

class KPushButton;

/** @short A warning message dialog (displayed before action execution). */
class MMessageDialog: public KDialog
{
	TQ_OBJECT
public:
	/**
	 * Constructor.
	 * @param delay A timeout in seconds
	 * @param actionToExecute An action to execute after click on the button,
	 * or after timeout
	 * @param text A message text
	 */
	MMessageDialog(const int delay, const Action::Type actionToExecute, const TQString &text);

	/**
	 * Destructor.
	 */
	virtual ~MMessageDialog();

	static void cancel();
	static bool show(const int timeout);
private:
	int
		_dialogDelay,
		_lastTime;
	Action::Type _action;
	KPushButton *b_continue;
	static MMessageDialog *_instance;
	TQLCDNumber *l_seconds;
	TQTimer *_checkTimer;
private slots:
	void slotAccept();
	void slotEnableContinue();
	void slotCheckTime();
	void slotReject();
};

#endif // __MMESSAGEDIALOG_H__
