/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <tdemessagebox.h>


#include "parsingHelper.h"
#include "apacheReader.h"

ApacheReader::ApacheReader(TQObject *parent, const char *name) : 
	DefaultReader(parent, name)
	{
	
	initializeTypeLevels();
}


ApacheReader::~ApacheReader() {

}


void ApacheReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Client"), true, false));
	columns->append(new LogViewColumn(i18n("Message"), true, false));

}

LogLine* ApacheReader::parseMessage(TQString& logLine, LogFile* logFile) {

	/*
	 * Log line examples :
	 * [Wed May 18 22:16:02 2005] [error] [client 127.0.0.1] File does not exist: /var/www/html/ksystemlog/screenshots/small/kernel-view.png, referer: http://localhost.localdomain/ksystemlog/screenshots.php
	 * [Wed May 18 22:16:02 2005] [error] [client 127.0.0.1] File does not exist: /var/www/html/ksystemlog/screenshots/small/system-filter.png, referer: http://localhost.localdomain/ksystemlog/screenshots.php
	 * [Thu May 19 18:00:19 2005] [notice] mod_jk2.post_config() first invocation
	 * [Thu May 19 18:00:19 2005] [notice] Digest: generating secret for digest authentication ...
	 * [client 127.0.0.1] PHP Parse error:  parse error, unexpected T_PRIVATE, expecting T_STRING in /mnt/boulot/web/annivernet/src/fonctions/formulaire.inc.php on line 25
	 */
	
	
	TQDate date;
	TQTime time;
	
	TQString level;
	
	//Temporary variable
	int squareBracket;
	
	//Special case which sometimes happens
	if (logLine.find("[client")==0) {
		date=TQDate::currentDate();
		time=TQTime::currentTime();
		level="notice";
	}
	else {
	
		//The Date
		int dateBegin=logLine.find("[");
		int dateEnd=logLine.find("]");
		
		TQString type;
		TQString message;
	
	
		TQString strDate=logLine.mid(dateBegin+1, dateEnd-dateBegin-1);
		
		TQString month=strDate.mid(4, 3);
		
		TQString day=strDate.mid(8, 2);
		
		TQString hour=strDate.mid(11, 2);
		TQString min=strDate.mid(14, 2);
		TQString sec=strDate.mid(17, 2);
		
		TQString year=strDate.mid(20, 4);
	
		date=TQDate(year.toInt(), ParsingHelper::parseMonthNumber(month), day.toInt());
		time=TQTime(hour.toInt(), min.toInt(), sec.toInt());
	
		logLine=logLine.remove(0, dateEnd+3);
	

		//The log level
		
		squareBracket=logLine.find("]");
		level=logLine.left(squareBracket);
		logLine=logLine.remove(0, squareBracket+2);
	}
	
	//The client
	int beginSquareBracket=logLine.find("[client");
	squareBracket=logLine.find("]");
	TQString client;
	if (beginSquareBracket==-1 || squareBracket==-1) {
		client="";
	}
	else {
		client=logLine.mid(8, squareBracket-8); //8=strlen("[client ")
		logLine=logLine.remove(0, squareBracket+2);
	}
	

	TQStringList list;
	list.push_back(client);
	list.push_back(logLine);
	
	TQString filePath=logFile->url.path();
		
	LogLine* line=new LogLine(date, time, list, filePath, getTypeLevel(level), Globals::apacheMode->id);
	
	return(line);
}


void ApacheReader::initializeTypeLevels() {
	mapTypeLevels["notice"]=Globals::informationLogLevel;
	mapTypeLevels["warn"]=Globals::warningLogLevel;
	mapTypeLevels["error"]=Globals::errorLogLevel;
}

LogLevel* ApacheReader::getTypeLevel(const TQString& type) {
	TQMap<TQString, LogLevel*>::iterator it;
	
	it=mapTypeLevels.find(type);
	if (it!=mapTypeLevels.end()) {
		return(*it);
	}
	else {
		kdDebug() << i18n("New Log Level detected: Please send this log file to the KSystemLog developer to add it.") << endl;
		return(Globals::noneLogLevel);
	}
}


#include "apacheReader.moc"
