###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )

set( ENV{PKG_CONFIG_PATH} "${PKG_CONFIG_PATH}:$ENV{PKG_CONFIG_PATH}:${LIB_INSTALL_DIR}/pkgconfig" )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for libgmp

pkg_search_module( GMP gmp )
if( NOT GMP_FOUND )
  find_library( GMP_LIBRARIES gmp )
  if( NOT GMP_LIBRARIES )
    tde_message_fatal( "libgmp is required but not found on your system" )
  endif()
endif( )


##### check for avahi

if( WITH_ZEROCONF )
  pkg_search_module( AVAHI_TQT avahi-tqt )
  pkg_search_module( AVAHI_CLIENT avahi-client )
  if( NOT AVAHI_TQT_FOUND OR NOT AVAHI_CLIENT_FOUND OR AVAHI_CLIENT_VERSION VERSION_LESS "0.6.10")
    tde_message_fatal( "avahi >= 0.6.10 support is requested, but not found on your system" )
  endif( )
endif( )


##### check for geoip

if( WITH_SYSTEM_GEOIP )
  pkg_search_module( GEOIP geoip )
  if( NOT GEOIP_FOUND )
    tde_message_fatal( "GeoIP is required but was not found on your system" )
  endif( )
  set( USE_SYSTEM_GEOIP 1 )
  # The use of the system-wide geoip database disables the use of the builtin one
  set( WITH_BUILTIN_GEOIP OFF )
endif( )


##### check for various fuctions, headers and types

check_function_exists( posix_fallocate   HAVE_POSIX_FALLOCATE )
check_function_exists( posix_fallocate64 HAVE_POSIX_FALLOCATE64 )
check_function_exists( fopen64           HAVE_FOPEN64 )
check_function_exists( ftruncate64       HAVE_FTRUNCATE64 )
check_function_exists( lseek64           HAVE_LSEEK64 )
check_function_exists( mmap64            HAVE_MMAP64 )
check_function_exists( munmap64          HAVE_MUNMAP64 )
check_function_exists( statvfs           HAVE_STATVFS )
check_function_exists( statvfs64         HAVE_STATVFS64 )

check_function_exists( fseeko64 _HAVE_FSEEKO64 )
check_function_exists( ftello64 _HAVE_FTELLO64 )
if( _HAVE_FSEEKO64 AND _HAVE_FTELLO64 )
  set( HAVE_FSEEKO64 1 )
endif( )

check_function_exists( stat64  _HAVE_STAT64 )
check_function_exists( fstat64 _HAVE_FSTAT64 )
if( _HAVE_FSTAT64 AND _HAVE_STAT64 )
  set( HAVE_STAT64 1 )
endif( )

check_include_file( "xfs/xfs.h" HAVE_XFS_XFS_H )

tde_save_and_set( CMAKE_REQUIRED_INCLUDES )
check_cxx_source_compiles( "
  #include <xfs/xfs.h>
  int main() { __s64 u; return 0; } "
  HAVE___S64
)
check_cxx_source_compiles( "
  #include <xfs/xfs.h>
  int main() { __u64 u; return 0; } "
  HAVE___U64
)
tde_restore( CMAKE_REQUIRED_INCLUDES )
