///////////////////////////////////////////////////////////////////////////////
//
//   File : kvi_styled_controls.cpp
//   Creation date : 19  Jan 2006 GMT by Alexey Uzhva
//
//   This toolbar is part of the KVirc irc client distribution
//   Copyright (C) 2006 Alexey Uzhva
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
///////////////////////////////////////////////////////////////////////////////


#define __KVIRC__

#include "kvi_styled_controls.h"


#include "kvi_iconmanager.h"
#include "kvi_app.h"
#include "kvi_options.h"
#include "kvi_doublebuffer.h"
#include "kvi_tal_toolbar.h"

#include <tqcheckbox.h>
#include <tqpainter.h>
#include <tqimage.h>
#include <tqevent.h>
#include <tqtimer.h>


KviStyledControlInternal::KviStyledControlInternal( KviStyledControl* control)
:TQObject(0,0)
{
	m_pControl=control;
}

KviStyledControlInternal::~KviStyledControlInternal()
{
	
}

bool KviStyledControlInternal::eventFilter( TQObject *obj, TQEvent *ev )
{
	if(ev->type()==TQEvent::Enter)
	{
		m_pControl->enterEvent(ev);
	} else if(ev->type()==TQEvent::Leave) {
		m_pControl->leaveEvent(ev);
	}
	return false;
}

void KviStyledControlInternal::paintTimerShot ()
{
//	tqDebug("%s %s %i",__FILE__,__FUNCTION__,__LINE__);
//	tqDebug("%s %i",__FUNCTION__,m_pControl->m_iStepNumber);
	if(m_pControl->m_bMouseEnter)
	{
		m_pControl->m_iStepNumber++;
		if(m_pControl->m_iStepNumber>=KVI_STYLE_NUM_STEPS)
		{
			m_pControl->m_iStepNumber=KVI_STYLE_NUM_STEPS;
			m_pControl->m_pTimer->stop();
		}
	} else {
		m_pControl->m_iStepNumber--;
		if(m_pControl->m_iStepNumber<=0) 
		{
			m_pControl->m_iStepNumber=0;
			m_pControl->m_pTimer->stop();
		}
	}
	m_pControl->m_pWidget->repaint( false );
}

KviStyledControl::KviStyledControl(TQWidget* w)
{
	m_pWidget=w;
	m_iStepNumber=0;
	m_bMouseEnter=0;
	m_pInternal=new KviStyledControlInternal(this);
	m_pTimer = new TQTimer(m_pInternal);
	m_pWidget->installEventFilter(m_pInternal);
}

KviStyledControl::~KviStyledControl()
{
	delete m_pTimer;
	delete m_pInternal;
}

void KviStyledControl::enterEvent ( TQEvent * )
{
//	tqDebug("%s %s %i",__FILE__,__FUNCTION__,__LINE__);
	if(m_pWidget->isEnabled() && KVI_OPTION_BOOL(KviOption_boolEnableVisualEffects))
	{
		if(m_iStepNumber<KVI_STYLE_NUM_STEPS)
		{
			if(!m_pTimer->isActive()) 
			{
				m_pTimer->connect( m_pTimer, TQ_SIGNAL(timeout()), m_pInternal, TQ_SLOT(paintTimerShot()) );
				m_pTimer->start(KVI_STYLE_TIMER_STEP);
			}
		}
		m_bMouseEnter=1;
		m_iStepNumber++;
		m_pWidget->repaint( false );
	}
}

void KviStyledControl::leaveEvent ( TQEvent * )
{
//	tqDebug("%s %s %i",__FILE__,__FUNCTION__,__LINE__);
	if(m_pWidget->isEnabled() && KVI_OPTION_BOOL(KviOption_boolEnableVisualEffects))
	{
		if(m_iStepNumber>0) 
		{
			if(!m_pTimer->isActive())
			{
				m_pTimer->connect( m_pTimer, TQ_SIGNAL(timeout()), m_pInternal, TQ_SLOT(paintTimerShot()) );
				m_pTimer->start(KVI_STYLE_TIMER_STEP);
			}
		}
		m_bMouseEnter=0;
		m_iStepNumber--;
		m_pWidget->repaint( false );
	}
}


KviStyledCheckBox::KviStyledCheckBox ( TQWidget * parent, const char * name )
: TQCheckBox(parent,name), KviStyledControl(this)
{
	setWFlags(WNoAutoErase);

}

KviStyledCheckBox::KviStyledCheckBox ( const TQString & text, TQWidget * parent, const char * name )
: TQCheckBox(text,parent,name), KviStyledControl(this)
{
	setWFlags(WNoAutoErase);
}

KviStyledCheckBox::~KviStyledCheckBox()
{

}

	
void KviStyledCheckBox::paintEvent ( TQPaintEvent * event)
{
	//tqDebug("%s %s %i %i %i",__FILE__,__FUNCTION__,__LINE__,m_bMouseEnter,m_iStepNumber);
	if(KVI_OPTION_BOOL(KviOption_boolEnableVisualEffects))
	{
		KviDoubleBuffer doublebuffer(event->rect().width(),event->rect().height());
		TQPixmap * pDoubleBufferPixmap = doublebuffer.pixmap();
		
		TQRect rect=event->rect();
		pDoubleBufferPixmap->fill(this, rect.topLeft()); 
		
		TQPainter p(pDoubleBufferPixmap, this); 
		p.translate(-rect.x(), -rect.y()); 
		
		TQPixmap*  pStoredPix = 0;
		
		if(isChecked())
			pStoredPix=g_pIconManager->getBigIcon("kvi_checkbox_selected.png");
		else
			pStoredPix=g_pIconManager->getBigIcon("kvi_checkbox_unselected.png");
		//tqDebug("%s %s %i %i %i",__FILE__,__FUNCTION__,__LINE__,m_bMouseEnter,m_iStepNumber);
		if(pStoredPix)
		{
			//tqDebug("%s %s %i %i %i",__FILE__,__FUNCTION__,__LINE__,m_bMouseEnter,m_iStepNumber);
			TQPixmap pix=*pStoredPix;
			if(m_iStepNumber && isEnabled())
			{
				TQImage image = pix.convertToImage();
				for(int x=0; x<image.width(); x++)
					for(int y=0; y<image.height(); y++)
					{
						TQRgb rgb=image.pixel(x,y);
						rgb=tqRgba(
							tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber < 255 ? tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber : 255 ,
							tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber < 255 ? tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber : 255,
							tqBlue(rgb),
							tqAlpha(rgb)
							);
						image.setPixel(x,y,rgb);
					}
				p.drawImage(0,0,image);
				} else if( !isEnabled()) {
				TQImage image = pix.convertToImage();
				for(int x=0; x<image.width(); x++)
					for(int y=0; y<image.height(); y++)
					{
						//- From Black to Gray conversion for disabled mode.
						TQRgb rgb=image.pixel(x,y);
						rgb=tqRgba(
							tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber == 0 ? 180 : tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber,
							tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber == 0 ? 180 : tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber,
							tqBlue(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber == 0 ? 180 : tqBlue(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber,
							tqAlpha(rgb)
							);
						image.setPixel(x,y,rgb);
					}
				p.drawImage(0,0,image);
			} else {
			p.drawPixmap(0,0,pix);
			}
			//tqDebug("%s %s %i %i %i",__FILE__,__FUNCTION__,__LINE__,m_bMouseEnter,m_iStepNumber);
			TQString szText=text();
			szText=szText.remove("&");
			p.drawText(pix.width()+3,0,width(),height(),0,szText);
			bitBlt(this, rect.x(), rect.y(), pDoubleBufferPixmap, 0, 0, rect.width(), rect.height());
			//tqDebug("%s %s %i %i %i",__FILE__,__FUNCTION__,__LINE__,m_bMouseEnter,m_iStepNumber);
		} else	{
			TQCheckBox::paintEvent(event);
		}
	} else
		TQCheckBox::paintEvent(event);
}

KviStyledToolButton::KviStyledToolButton( TQWidget * parent, const char * name )
: TQToolButton(parent,name), KviStyledControl(this), bShowSubmenuIndicator(false)
{
	setWFlags(WNoAutoErase);
	resizeEvent(0);
}

KviStyledToolButton::KviStyledToolButton ( const TQIconSet & iconSet, const TQString & textLabel, const TQString & grouptext, TQObject * receiver, const char * slot, KviTalToolBar * parent, const char * name )
: TQToolButton(iconSet,textLabel,grouptext,receiver,slot,parent,name), KviStyledControl(this), bShowSubmenuIndicator(false)
{
	setWFlags(WNoAutoErase);
	resizeEvent(0);
}

KviStyledToolButton::~KviStyledToolButton()
{

}

void KviStyledToolButton::setShowSubmenuIndicator(bool bShow)
{
	bShowSubmenuIndicator=bShow;
	resizeEvent(0);
}

void KviStyledToolButton::paintEvent ( TQPaintEvent * event)
{
	if(KVI_OPTION_BOOL(KviOption_boolEnableVisualEffects))
	{
		TQPixmap*  pArrowPix = 0;
		int iWidth=width();
		int iPixWidth=0;
		if(bShowSubmenuIndicator)
		{
			if(pArrowPix=g_pIconManager->getBigIcon("kvi_toolbutton_menuindicator.png"))
				iPixWidth=pArrowPix->width();
		}
		bool bActive= isOn() || m_bMouseEnter;
		KviDoubleBuffer doublebuffer(event->rect().width(),event->rect().height());
		TQPixmap * pDoubleBufferPixmap = doublebuffer.pixmap();

		TQRect rect=event->rect();
		
		pDoubleBufferPixmap->fill(
			bActive ? TQColor(206,215,223) :
			colorGroup().background()
			);
		
		
		TQPainter p(pDoubleBufferPixmap, this); 
		p.translate(-rect.x(), -rect.y());
		
		if(bActive)
		{
			p.setPen(TQColor(185,190,195));
			p.drawRect(0,0,iWidth,height());
		}
		
		TQPixmap pix=iconSet().pixmap(
                                usesBigPixmap() ? TQIconSet::Large : TQIconSet::Small,
                                isEnabled() ? TQIconSet::Normal :
                                              TQIconSet::Disabled,
                                isOn() ? TQIconSet::On :
                                              TQIconSet::Off);
		TQPoint pos((iWidth-iPixWidth-pix.width())/2,(height()-pix.height())/2);
		if(!pix.isNull())
		{
			if(m_iStepNumber && isEnabled())
			{
				TQImage image = pix.convertToImage();
				for(int x=0; x<image.width(); x++)
					for(int y=0; y<image.height(); y++)
					{
						TQRgb rgb=image.pixel(x,y);
						rgb=tqRgba(
							tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber < 255 ? tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber : 255 ,
							tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber < 255 ? tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber : 255,
							tqBlue(rgb),
							tqAlpha(rgb)
							);
						image.setPixel(x,y,rgb);
					}
				p.drawImage(pos,image);
				} else if( !isEnabled()) {
				TQImage image = pix.convertToImage();
				for(int x=0; x<image.width(); x++)
					for(int y=0; y<image.height(); y++)
					{
						//- From Black to Gray conversion for disabled mode.
						TQRgb rgb=image.pixel(x,y);
						rgb=tqRgba(
							tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber == 0 ? 180 : tqRed(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber,
							tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber == 0 ? 180 : tqGreen(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber,
							tqBlue(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber == 0 ? 180 : tqBlue(rgb)+KVI_STYLE_COLOR_DIFF/KVI_STYLE_NUM_STEPS*m_iStepNumber,
							tqAlpha(rgb)
							);
						image.setPixel(x,y,rgb);
					}
				p.drawImage(pos,image);
			} else {
			p.drawPixmap(pos,pix);
			}
		}
		
		if(pArrowPix)
		{
			pos.setX(pix.width()+4);
			pos.setY((height()-pArrowPix->height())/2);
			p.drawPixmap(pos,*pArrowPix);
		}

		bitBlt(this, rect.x(), rect.y(), pDoubleBufferPixmap, 0, 0, rect.width(), rect.height());
		
	} else {
		TQToolButton::paintEvent(event);
	}
}

void KviStyledToolButton::resizeEvent ( TQResizeEvent * e)
{
	TQPixmap*  pStoredPix = 0;
	if(pStoredPix=g_pIconManager->getBigIcon("kvi_toolbutton_menuindicator.png"))
	{
		TQPixmap pix=iconSet().pixmap(
                                usesBigPixmap() ? TQIconSet::Large : TQIconSet::Small,
                                isEnabled() ? TQIconSet::Normal :
                                              TQIconSet::Disabled,
                                isOn() ? TQIconSet::On :
                                              TQIconSet::Off);
		
		setMinimumWidth(bShowSubmenuIndicator ? pix.width()+8+pStoredPix->width() : pix.width());
	}
}

#include "kvi_styled_controls.moc"

