#ifndef _ALIASEDITOR_H_
#define _ALIASEDITOR_H_
//=====================================================================================
//
//   File : aliaseditor.h
//   Creation date : Mon Dec 23 2002 14:35:55 CEST by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2002-2005 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the linkss of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=====================================================================================

#include "kvi_window.h"
#include "kvi_string.h"
#include "kvi_pointerlist.h"


#include <tqwidget.h>
#include "kvi_tal_listview.h"
#include <tqlineedit.h>
#include "kvi_tal_popupmenu.h"
#include <tqstringlist.h>
#include <tqpushbutton.h>
#include <tqlabel.h>

class KviScriptEditor;
class KviAliasNamespaceListViewItem;


class KviAliasEditorListViewItem : public KviTalListViewItem
{
public:
	enum Type { Alias, Namespace };
public:
	KviAliasEditorListViewItem(KviTalListView * pListView,Type eType,const TQString &szName);
	KviAliasEditorListViewItem(KviAliasNamespaceListViewItem * pParentNamespaceItem,Type eType,const TQString &szName);
	~KviAliasEditorListViewItem(){};
protected:
	Type m_eType;
	KviAliasNamespaceListViewItem * m_pParentNamespaceItem;
	TQString m_szName;
public:
	const TQString & name(){ return m_szName; };
	void setName(const TQString &szName);
	Type type(){ return m_eType; };
	bool isAlias(){ return m_eType == Alias; };
	bool isNamespace(){ return m_eType == Namespace; };
	void setParentNamespaceItem(KviAliasNamespaceListViewItem* it){ m_pParentNamespaceItem=it; };
	KviAliasNamespaceListViewItem * parentNamespaceItem(){ return m_pParentNamespaceItem; };
	virtual TQString key(int column,bool bAsc) const;
};

class KviAliasListViewItem;

class KviAliasNamespaceListViewItem : public KviAliasEditorListViewItem
{
public:
	KviAliasNamespaceListViewItem(KviTalListView * pListView,const TQString &szName);
	KviAliasNamespaceListViewItem(KviAliasNamespaceListViewItem * pParentNamespace,const TQString &szName);
	~KviAliasNamespaceListViewItem(){};
public:
	KviAliasNamespaceListViewItem * findNamespaceItem(const TQString &szName);
	KviAliasNamespaceListViewItem * getNamespaceItem(const TQString &szName);
	KviAliasListViewItem * findAliasItem(const TQString &szName);
	KviAliasListViewItem * getAliasItem(const TQString &szName);
	KviAliasListViewItem * createFullAliasItem(const TQString &szFullName);
	KviAliasNamespaceListViewItem * createFullNamespaceItem(const TQString &szFullName);
};


class KviAliasListViewItem : public KviAliasEditorListViewItem
{
public:
	KviAliasListViewItem(KviAliasNamespaceListViewItem * pParentNamespace,const TQString &szName);
	KviAliasListViewItem(KviTalListView *pListView,const TQString &szName);
	~KviAliasListViewItem(){};
public:
	TQString m_szBuffer;
	TQPoint  m_cPos;
public:
	const TQString & buffer(){ return m_szBuffer; };
	const TQPoint & cursorPosition(){ return m_cPos; };
	void setBuffer(const TQString &szBuffer){ m_szBuffer = szBuffer; };
	void setCursorPosition(const TQPoint &cPos){ m_cPos = cPos; };
};

class TQSplitter;

class KviAliasEditor : public TQWidget
{
	TQ_OBJECT
  
public:
	KviAliasEditor(TQWidget * par);
	~KviAliasEditor();
public:
	KviScriptEditor            * m_pEditor;
	KviTalListView                  * m_pListView;
	TQLabel                     * m_pNameLabel;
	TQPushButton                * m_pRenameButton;
	KviAliasEditorListViewItem * m_pLastEditedItem;
	KviAliasEditorListViewItem * m_pLastClickedItem;
	//KviAliasListViewItem * m_pLastEditedItem;
	KviTalPopupMenu                 * m_pContextPopup;
	TQSplitter                  * m_pSplitter;
	TQString						m_szDir;
public:
	//bool modified(){ return m_bModified; };
	void commit();
	void exportAliases(bool,bool=false);
	void exportSelectionInSinglesFiles(KviPointerList<KviAliasListViewItem> *l);

	void saveProperties(KviConfig *);
	void loadProperties(KviConfig *);
	static void splitFullAliasOrNamespaceName(const TQString &szFullName,TQStringList &lNamespaces,TQString &szName);
protected slots:
	void currentItemChanged(KviTalListViewItem *it);
	void newAlias();
	void newNamespace();
	void exportAll();
	void exportSelectedSepFiles();
	void exportSelected();
	void removeSelectedItems();
	void itemPressed(KviTalListViewItem *it,const TQPoint &pnt,int col);
	void renameItem();
	void slotFind();
	void slotCollapseNamespaces();
	void slotFindWord(const TQString &);
	void slotReplaceAll(const TQString &before,const TQString &after);
protected:
//	TQString const & findWord(const TQString &txt,bool);
	void recursiveCollapseNamespaces(KviAliasEditorListViewItem * it);
	void recursiveSearchReplace(const TQString &szSearch,KviAliasEditorListViewItem * it,bool bReplace=false,const TQString &szReplace="n");
	
	void recursiveCommit(KviAliasEditorListViewItem * it);
	void getExportAliasBuffer(TQString &buffer,KviAliasListViewItem * it);
	void oneTimeSetup();
	void selectOneItem(KviTalListViewItem * it,KviTalListViewItem *pStartFrom);
	void saveLastEditedItem();
	void getUniqueItemName(KviAliasEditorListViewItem *item,TQString &buffer,KviAliasEditorListViewItem::Type eType);
	void appendSelectedItems(KviPointerList<KviAliasEditorListViewItem> * l,KviAliasEditorListViewItem * pStartFrom,bool bIncludeChildrenOfSelected = false);
	void appendAliasItems(KviPointerList<KviAliasListViewItem> * l,KviAliasEditorListViewItem * pStartFrom,bool bSelectedOnly);
	void appendNamespaceItems(KviPointerList<KviAliasListViewItem> * l,KviAliasEditorListViewItem * pStartFrom,bool bSelectedOnly);
	bool removeItem(KviAliasEditorListViewItem *it,bool * pbYesToAll,bool bDeleteEmptyTree);
	void openParentItems(KviTalListViewItem * it);
	void activateItem(KviTalListViewItem * it);
	TQString askForAliasName(const TQString &szAction,const TQString &szText,const TQString &szInitialText);
	TQString askForNamespaceName(const TQString &szAction,const TQString &szText,const TQString &szInitialText);
	bool itemExists(KviTalListViewItem *pSearchFor,KviTalListViewItem * pSearchAt);
	bool namespaceExists(TQString &szFullItemName);
	bool aliasExists(TQString &szFullItemName);
	bool hasSelectedItems(KviTalListViewItem * it);
	KviAliasNamespaceListViewItem * findNamespaceItem(const TQString &szName);
	KviAliasNamespaceListViewItem * getNamespaceItem(const TQString &szName);
	KviAliasListViewItem * findAliasItem(const TQString &szName);
	KviAliasListViewItem * getAliasItem(const TQString &szName);
	KviAliasListViewItem * createFullAliasItem(const TQString &szFullName);
	KviAliasNamespaceListViewItem * createFullNamespaceItem(const TQString &szFullName);
	TQString buildFullItemName(KviAliasEditorListViewItem * it);
};


class KviAliasEditorWindow : public KviWindow
{
	TQ_OBJECT
  
public:
	KviAliasEditorWindow(KviFrame * lpFrm);
	~KviAliasEditorWindow();
protected:
	KviAliasEditor * m_pEditor;
	TQWidget        * m_pBase;
protected:
	virtual TQPixmap * myIconPtr();
	virtual void resizeEvent(TQResizeEvent *e);
	virtual void getConfigGroupName(KviStr &szName);
	virtual void saveProperties(KviConfig *);
	virtual void loadProperties(KviConfig *);
protected slots:
	void cancelClicked();
	void okClicked();
	void applyClicked();
};

#endif //_ALIASEDITOR_H_
