/***************************************************************************
                          kxespecprocinstrdialog.cpp  -  description
                          --------------------------
    begin                : Ne ?ec 6 2003
    copyright            : (C) 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxespecprocinstrdialog.h"

#include "kxmleditorfactory.h"
#include "kxeconfiguration.h"
#include "kxenewfilesettings.h"

#include <tqstring.h>
#include <tqcombobox.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqregexp.h>
#include <tqframe.h>
#include <tqcheckbox.h>

#include <kdebug.h>

KXESpecProcInstrDialog::KXESpecProcInstrDialog(TQWidget *parent, const char *name )
  : KXESpecProcInstrDialogBase(parent,name)
{
  m_pComboBoxEncoding->insertStringList( KXMLEditorFactory::configuration()->newfile()->encodings() );
  
  m_pLineEditVersion->setText("1.0");

  m_pHLine->hide();
  m_pDontShowAgain->hide();

  // signals and slots connections
  connect( m_pBtnOK, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotAccept() ) );
}

KXESpecProcInstrDialog::~KXESpecProcInstrDialog()
{
}

void KXESpecProcInstrDialog::fillDialog( const TQString strData )
{
  TQString strVersion;
  TQString strEncoding;

  int iStart, iEnd;

  // find version info
  if((iStart = strData.find("version", 0)) >= 0)
  {
    // info about encoding found;
    iStart += 7; // skip version

    // search " or ' after encoding
    if((iStart = strData.find(TQRegExp("[\"']"), iStart)) > 0)
    {
      TQChar ch = strData[iStart];
      iStart++; // skip ch
      if((iEnd = strData.find(ch, iStart)) > 0)
        strVersion = strData.mid(iStart, iEnd - iStart); 
    }
  }
  else
    strVersion = "1.0";
  
  // find encoding info
  if((iStart = strData.find("encoding", 0)) >= 0)
  {
    // info about encoding found;
    iStart += 8; // skip encoding

    // search " or ' after encoding
    if((iStart = strData.find(TQRegExp("[\"']"), iStart)) > 0)
    {
      TQChar ch = strData[iStart];
      iStart++; // skip ch
      if((iEnd = strData.find(ch, iStart)) > 0)
        strEncoding = strData.mid(iStart, iEnd - iStart);
    }
  }
  else
    strEncoding = "UTF-8";
  

  m_pLineEditVersion->setText(strVersion);
	m_pComboBoxEncoding->setCurrentText(strEncoding);
}

int KXESpecProcInstrDialog::exec()
{
	m_pBtnOK->setDefault(true);

	return KXESpecProcInstrDialogBase::exec();
}


/** Called when user press OK button */
void KXESpecProcInstrDialog::slotAccept()
{
  accept();
}


/*!
    Initializes content of dialog controls with specified values.
    	@param version XML file version
	@param encoding encoding type for the XML file
 */
void KXESpecProcInstrDialog::fillDialog(const TQString& version, const TQString& encoding)
{

	m_pLineEditVersion->setText(version);
	m_pComboBoxEncoding->setCurrentText(encoding);
}


/*!
    Returns content of the dialog as an string of format: '"version = '...' encoding = '...' ".
 */
TQString KXESpecProcInstrDialog::getData()
{
    return 		TQString("version = '")+m_pLineEditVersion->text()+
				"' encoding = '"+m_pComboBoxEncoding->currentText()+"' ";
}

#include "kxespecprocinstrdialog.moc"
