/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef DOMTOOL_H
#define DOMTOOL_H

#include <ntqvariant.h>
#include <ntqnamespace.h>

class TQDomElement;
class TQDomDocument;

class DomTool : public TQt
{
public:
    static TQVariant readProperty( const TQDomElement& e, const TQString& name, const TQVariant& defValue );
    static TQVariant readProperty( const TQDomElement& e, const TQString& name, const TQVariant& defValue, TQString& comment );
    static bool hasProperty( const TQDomElement& e, const TQString& name );
    static TQStringList propertiesOfType( const TQDomElement& e, const TQString& type );
    static TQVariant elementToVariant( const TQDomElement& e, const TQVariant& defValue );
    static TQVariant elementToVariant( const TQDomElement& e, const TQVariant& defValue, TQString &comment );
    static TQVariant readAttribute( const TQDomElement& e, const TQString& name, const TQVariant& defValue );
    static TQVariant readAttribute( const TQDomElement& e, const TQString& name, const TQVariant& defValue, TQString& comment );
    static bool hasAttribute( const TQDomElement& e, const TQString& name );
    static TQColor readColor( const TQDomElement &e );
    static void fixDocument( TQDomDocument& );
};


#endif // DOMTOOL_H
