/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "mem24_group.h"

#include "mem24_memory.h"

Device::Memory *Mem24::Group::createMemory(const Device::Data &data) const
{
  return new Memory(static_cast<const Mem24::Data &>(data));
}

TQString Mem24::Group::informationHtml(const Device::Data &data) const
{
  const Mem24::Data &mdata = static_cast<const Mem24::Data &>(data);
  TQString tmp = i18n("%1 bytes").arg(formatNumber(mdata.nbBytes()));
  return htmlTableRow(i18n("Memory Size"), tmp);
}

#if !defined(NO_KDE)
TQPixmap Mem24::Group::memoryGraph(const Device::Data &data) const
{
  const Mem24::Data &mdata = static_cast<const Mem24::Data &>(data);
  uint offset = 0x0;
  TQValueList<Device::MemoryGraphData> ranges;
  for (uint i=0; i<mdata.nbBlocks(); i++) {
    Device::MemoryGraphData data;
    data.startAddress = offset;
    offset += mdata.nbBytes() / mdata.nbBlocks();
    data.endAddress = offset - 1;
    data.start = toHexLabel(data.startAddress, mdata.nbCharsAddress());
    data.end = toHexLabel(data.endAddress, mdata.nbCharsAddress());
    data.label = i18n("Block #%1").arg(i+1);
    ranges.append(data);
  }
  return Device::memoryGraph(ranges);
}
#endif
