/*  This file is part of the TDE project
    Copyright (C) 2007-2008 Gökçen Eraslan <gokcen@pardus.org.tr>
    Copyright (C) 2008 Daniel Nicoletti <dantti85-pk@yahoo.com.br>
    Copyright (C) 2010 Dario Freddi <drf@kde.org>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef AUTHDIALOG_H
#define AUTHDIALOG_H

#include <kdialogbase.h>
#include "AuthDetailsWidget.h"

#include <PolkitTQt/Identity>
#include <PolkitTQt/ActionDescription>

namespace PolkitTQt
{
class Details;
}

class AuthDialogWidget;

class AuthDialog : public KDialogBase
{
  TQ_OBJECT

  public:
    AuthDialog(const TQString &actionId, const TQString &message,
            const TQString &iconName, const PolkitTQt::Details &details,
            const PolkitTQt::Identity::List &identities);
    ~AuthDialog();

    void setRequest(const TQString &request, bool requiresAdmin);
    void setOptions();
    void authenticationFailure();
    TQString password() const;
    PolkitTQt::Identity adminUserSelected() const;

    PolkitTQt::ActionDescription m_actionDescription;

  signals:
    void adminUserSelected(const PolkitTQt::Identity&);

  public slots:
    virtual void accept();

  private slots:
    void on_userCB_currentIndexChanged(int index);

  private:
    TQString m_appname;
    TQString m_message;
    AuthDialogWidget *m_authWidget;
    TQStringList m_userData;

    void createUserCB(const PolkitTQt::Identity::List &identities);
};

class AuthDetails : public AuthDetailsWidget
{
  TQ_OBJECT

  public:
    AuthDetails(const PolkitTQt::Details &details,
            const PolkitTQt::ActionDescription &actionDescription,
             const TQString &appname, TQWidget *parent);

  private slots:
    void openUrl(const TQString &url);
};

#endif

