labelText = 'TQTable'
iconName = 'inline_table'

helpText = """From the docs: 'The TQTable class provides a flexible 
editable table widget.'
"""

import csv
import os

from PyTQt.tqt import TQFrame, TQStringList, TQVBoxLayout, TQ_SIGNAL
from PyTQt.tqttable import TQTable

from tdeui import KTextEdit

contrib = os.path.join(os.path.split(__file__)[0], 'CONTRIB')


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)

        data = csv.reader(open(contrib))
        header = next(data)
        items = [item for item in data]

        self.table = table = TQTable(len(items), len(header), self)
        headers = TQStringList()
        for headertext in header:
            headers.append(headertext)
        table.setColumnLabels(headers)

        cols = range(len(header))
        for row, record in enumerate(items):
            for col in cols:
                table.setText(row, col, record[col])

        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        layout.addWidget(self.table)
        layout.addStretch(1)
