#!/usr/bin/env python

# TQt tutorial 6.

import sys
from PyTQt import tqt


class LCDRange(tqt.TQVBox):
    def __init__(self, parent=None, name=None):
        tqt.TQVBox.__init__(self, parent, name)

        lcd = tqt.TQLCDNumber(2, self, "lcd")
        slider = tqt.TQSlider(tqt.TQt.Horizontal, self, "slider")
        slider.setRange(0, 99)
        slider.setValue(0)
        self.connect(slider, tqt.TQ_SIGNAL("valueChanged(int)"), lcd, tqt.TQ_SLOT("display(int)"))


class MyWidget(tqt.TQVBox):
    def __init__(self, parent=None, name=None):
        tqt.TQVBox.__init__(self, parent, name)

        quit = tqt.TQPushButton("Quit", self, "quit")
        quit.setFont(tqt.TQFont("Times", 18, tqt.TQFont.Bold))

        self.connect(quit, tqt.TQ_SIGNAL("clicked()"), tqt.tqApp, tqt.TQ_SLOT("quit()"))

        grid = tqt.TQGrid(4, self)

        for c in range(4):
            for r in range(4):
                LCDRange(grid)


a = tqt.TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
