/***************************************************************************
    smb4kmounter_p  -  This is a private helper class for Smb4KMounter.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KMOUNTER_P_H
#define SMB4KMOUNTER_P_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqthread.h>
#include <tqstring.h>

// KDE includes
#include <kdebug.h>

// system includes
#include <sys/statvfs.h>

class Smb4KMounterPrivate
{
  public:
    Smb4KMounterPrivate();
    ~Smb4KMounterPrivate();
    int timerTicks;

    class Thread : public TQThread
    {
      public:
        Thread() : TQThread(), m_mountpoint( TQString() ), m_broken( true ) {}
        ~Thread() {}

        void setMountpoint( const TQString &mp ) { m_mountpoint = mp; }

        virtual void run()
        {
          if ( m_mountpoint.isEmpty() )
          {
            kdFatal() << "Smb4KMounterPrivate::Thread: No mountpoint specified" << endl;
          }

          struct statvfs fs;

          if ( statvfs( m_mountpoint.local8Bit(), &fs ) == -1 )
          {
            m_broken = true;
            m_total = -1;
            m_free = -1;
          }
          else
          {
            m_broken = false;

            double kB_block = (double)(fs.f_bsize / 1024);
            double total = (double)(fs.f_blocks*kB_block);
            double free = (double)(fs.f_bfree*kB_block);

            m_total = total;
            m_free = free;
          }

          m_mountpoint = TQString();
        }

        bool isBroken() { return m_broken; }
        double totalDiskSpace() { return m_total; }
        double freeDiskSpace() { return m_free; }

      private:
        TQString m_mountpoint;
        bool m_broken;
        double m_total;
        double m_free;
    };

    Thread thread;
    void clearData();
    const TQString &workgroup();
    const TQString &host();
    const TQString &share();
    const TQString &ip();
    const TQString &path();
    const TQString &filesystem();
    const TQString &cifsLogin();
    void setWorkgroup ( const TQString &wg );
    void setHost( const TQString &h );
    void setShare( const TQString &s );
    void setIP( const TQString &i );
    void setPath( const TQString &p );
    void setFileSystem( const TQString &f );
    void setCIFSLogin( const TQString &l );

  private:
    TQString m_workgroup;
    TQString m_host;
    TQString m_share;
    TQString m_ip;
    TQString m_path;
    TQString m_filesystem;
    TQString m_cifsLogin;
};

#endif
