###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### find python libraries

if( ${CMAKE_VERSION} VERSION_LESS "3.12" )
  find_package( PythonInterp )
  find_package( PythonLibs )
  if( NOT PYTHONLIBS_FOUND )
    tde_message_fatal( "Python is required, but was not found on your system" )
  endif( NOT PYTHONLIBS_FOUND )
else( )
  find_package( Python COMPONENTS Interpreter Development )
  if( NOT Python_Development_FOUND )
    tde_message_fatal( "Python is required, but was not found on your system" )
  endif( )
  set( PYTHON_EXECUTABLE  ${Python_EXECUTABLE} )
  set( PYTHON_INCLUDE_DIR ${Python_INCLUDE_DIRS} )
  set( PYTHON_LIBRARIES   ${Python_LIBRARIES} )
endif( )


##### find python setuptools location and set tde-guidance package location

execute_process(
	COMMAND "${PYTHON_EXECUTABLE}" -c "import os; import setuptools; print(os.path.dirname(setuptools.__path__[0]))"
  OUTPUT_VARIABLE TDE_GUIDANCE_DIST_PKG_PATH 
  OUTPUT_STRIP_TRAILING_WHITESPACE
)
set( TDE_GUIDANCE_DIST_PKG_PATH ${TDE_GUIDANCE_DIST_PKG_PATH}/tde-guidance )


##### find pytquic executable

find_program( PYTQUIC_EXECUTABLE NAMES pytquic )

if( NOT PYTQUIC_EXECUTABLE )
  tde_message_fatal( "pytquic is required, but was not found on your system" )
endif()


##### find pythonize library

find_library( PYTHONIZE_LIBRARIES pythonize HINTS ${LIB_INSTALL_DIR} )
if( "${PYTHONIZE_LIBRARIES}" STREQUAL "PYTHONIZE_LIBRARIES-NOTFOUND" )
  tde_message_fatal( "pythonize library is required, but was not found on your system" )
endif( )
